/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;

public class TimeZoneIds {
    static final long cNow = System.currentTimeMillis();
    private static final Logger log = Logger.getLogger(TimeZoneIds.class);
    static final ConcurrentMap<TimeZone, DateTimeZone> dateTimeZoneMap = new MapMaker().makeComputingMap((Function)new Function<TimeZone, DateTimeZone>(){

        public DateTimeZone apply(TimeZone timeZone) {
            return DateTimeZone.forTimeZone((TimeZone)timeZone);
        }
    });

    public static Set<String> getCanonicalIds() {
        HashSet<String> canonicalIds = new HashSet<String>();
        Set idSet = DateTimeZone.getAvailableIDs();
        Object[] zones = new ZoneData[idSet.size()];
        Iterator it = idSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String id = (String)it.next();
            zones[i++] = new ZoneData(id, DateTimeZone.forID((String)id));
        }
        Arrays.sort(zones);
        for (int i2 = 0; i2 < zones.length; ++i2) {
            Object zone = zones[i2];
            if (!((ZoneData)zone).isCanonical()) continue;
            canonicalIds.add(((ZoneData)zone).getCanonicalID());
        }
        return canonicalIds;
    }

    public static TimeZone ensureCanonicalTimeZone(TimeZone timeZone) {
        try {
            DateTimeZone dateTimeZone = (DateTimeZone)dateTimeZoneMap.get(timeZone);
            return dateTimeZone.toTimeZone();
        }
        catch (ComputationException ex) {
            log.debug((Object)("Time zone with id '" + timeZone.getID() + "' not recognised."));
            return timeZone;
        }
    }

    private static class ZoneData
    implements Comparable {
        private final String iID;
        private final DateTimeZone iZone;

        ZoneData(String id, DateTimeZone zone) {
            this.iID = id;
            this.iZone = zone;
        }

        public String getID() {
            return this.iID;
        }

        public String getCanonicalID() {
            return this.iZone.getID();
        }

        public boolean isCanonical() {
            return this.getID().equals(this.getCanonicalID());
        }

        public int compareTo(Object obj) {
            int offsetB;
            ZoneData other = (ZoneData)obj;
            int offsetA = this.iZone.getStandardOffset(cNow);
            if (offsetA < (offsetB = other.iZone.getStandardOffset(cNow))) {
                return -1;
            }
            if (offsetA > offsetB) {
                return 1;
            }
            int result = this.getCanonicalID().compareTo(other.getCanonicalID());
            if (result != 0) {
                return result;
            }
            if (this.isCanonical()) {
                if (!other.isCanonical()) {
                    return -1;
                }
            } else if (other.isCanonical()) {
                return 1;
            }
            return this.getID().compareTo(other.getID());
        }
    }
}

