/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.PrivateShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PrivateShareQueryFactory
implements ShareQueryFactory<PrivateShareTypeSearchParameter> {
    public Field getField(SharedEntity entity, SharePermission permission) {
        Assertions.not((String)"entity must be private", (!entity.getPermissions().isPrivate() ? 1 : 0) != 0);
        String ownerUserName = entity.getOwnerUserName();
        return new Field("owner", ownerUserName == null ? "" : ownerUserName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public Term[] getTerms(User user) {
        Term[] termArray;
        Term term = this.getTerm(null, user);
        if (term == null) {
            termArray = new Term[]{};
        } else {
            Term[] termArray2 = new Term[1];
            termArray = termArray2;
            termArray2[0] = term;
        }
        return termArray;
    }

    public Query getQuery(ShareTypeSearchParameter parameter, User user) {
        Term term = this.getTerm(null, user);
        return term == null ? null : new TermQuery(term);
    }

    public Query getQuery(ShareTypeSearchParameter parameter) {
        throw new UnsupportedOperationException("Can't query for Private Shares");
    }

    private Term getTerm(ShareTypeSearchParameter searchParameter, User user) {
        return user == null ? null : new Term("owner", user.getName());
    }

    private static final class Name {
        static final String FIELD = "owner";

        private Name() {
        }
    }
}

