/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CachingSharePermissionStore
implements SharePermissionStore,
Startable {
    private final SharePermissionStore delegateStore;
    private final Map<Key, SharedEntity.SharePermissions> cache = LRUMap.synchronizedLRUMap(3000);
    private final EventPublisher eventPublisher;

    public CachingSharePermissionStore(SharePermissionStore delegateStore, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        this.validate(entity);
        Key key = CachingSharePermissionStore.createKey(entity);
        SharedEntity.SharePermissions sharePermissions = this.cache.get(key);
        if (sharePermissions == null) {
            sharePermissions = this.delegateStore.getSharePermissions(entity);
            if (sharePermissions == null) {
                sharePermissions = SharedEntity.SharePermissions.PRIVATE;
            }
            this.cache.put(key, sharePermissions);
        }
        return sharePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteSharePermissions(SharedEntity entity) {
        this.validate(entity);
        try {
            int n = this.delegateStore.deleteSharePermissions(entity);
            return n;
        }
        finally {
            this.cache.remove(CachingSharePermissionStore.createKey(entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteSharePermissionsLike(SharePermission permission) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"permission.type", (Object)permission.getType());
        try {
            int n = this.delegateStore.deleteSharePermissionsLike(permission);
            return n;
        }
        finally {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedEntity.SharePermissions storeSharePermissions(SharedEntity entity) {
        this.validate(entity);
        Assertions.notNull((String)"permissions", (Object)entity.getPermissions());
        boolean addedToCache = false;
        try {
            SharedEntity.SharePermissions sharePermissions = this.delegateStore.storeSharePermissions(entity);
            if (sharePermissions == null) {
                sharePermissions = SharedEntity.SharePermissions.PRIVATE;
            }
            this.cache.put(CachingSharePermissionStore.createKey(entity), sharePermissions);
            addedToCache = true;
            SharedEntity.SharePermissions sharePermissions2 = sharePermissions;
            return sharePermissions2;
        }
        finally {
            if (!addedToCache) {
                this.cache.remove(CachingSharePermissionStore.createKey(entity));
            }
        }
    }

    private void validate(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.id", (Object)entity.getId());
        Assertions.notNull((String)"entity.entityType", (Object)entity.getEntityType());
    }

    private static Key createKey(SharedEntity entity) {
        return new Key(entity.getId(), entity.getEntityType().getName());
    }

    private static class Key {
        private final long id;
        private final String type;

        public Key(long id, String type) {
            Assertions.notBlank((String)"type", (String)type);
            this.id = id;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.id != key.id) {
                return false;
            }
            return this.type.equals(key.type);
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

