/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.jira.service.util.handler.AbstractCommentHandler;
import com.atlassian.mail.MailUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

public class RegexCommentHandler
extends AbstractCommentHandler {
    public static final String KEY_SPLITREGEX = "splitregex";
    private String splitRegex;

    public void init(Map params) {
        super.init(params);
        if (params.containsKey(KEY_SPLITREGEX)) {
            this.setSplitRegex((String)params.get(KEY_SPLITREGEX));
        }
    }

    @Override
    protected String getEmailBody(Message message) throws MessagingException {
        return this.splitMailBody(MailUtils.getBody((Message)message));
    }

    public String splitMailBody(String rawBody) {
        String splitRegex = this.getSplitRegex();
        try {
            if (StringUtils.isNotEmpty((String)splitRegex)) {
                ArrayList parts = new ArrayList();
                new Perl5Util().split(parts, splitRegex, rawBody);
                if (parts.isEmpty()) {
                    this.log.debug((Object)("Regex " + splitRegex + " did not match any text in email; using full text for comment."));
                } else if (parts.size() > 1) {
                    this.log.debug((Object)("Regex " + splitRegex + " matched " + parts.size() + " times; using first as comment."));
                    StringBuffer comment = new StringBuffer("\n");
                    comment.append(((String)parts.get(0)).trim());
                    comment.append("\n\n");
                    return comment.toString();
                }
            }
        }
        catch (MalformedPerl5PatternException pe) {
            this.log.error((Object)("Invalid regex in parameter splitregex=" + splitRegex + " on regex comment handler. Note that regex must be in the format /foo/, and cannot contain commas (as they are used for separating handler params). " + (Object)((Object)pe)), (Throwable)pe);
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"Failed to split email body. Appending raw content...", (Throwable)e);
        }
        return rawBody;
    }

    public String getSplitRegex() {
        return this.splitRegex;
    }

    public void setSplitRegex(String splitRegex) {
        this.splitRegex = splitRegex;
    }

    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

