/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.service.util.handler.AbstractCommentHandler;
import com.atlassian.mail.MailUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;

public class NonQuotedCommentHandler
extends AbstractCommentHandler {
    private static final String OUTLOOK_QUOTED_FILE = "outlook-email.translations";
    private Collection messages;

    @Override
    protected String getEmailBody(Message message) throws MessagingException {
        return this.stripQuotedLines(MailUtils.getBody((Message)message));
    }

    public String stripQuotedLines(String body) {
        String line1;
        if (body == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(body, "\n", true);
        StringBuffer result = new StringBuffer();
        boolean strippedAttribution = false;
        boolean outlookQuotedLine = false;
        String line2 = null;
        String line3 = null;
        do {
            line1 = line2;
            line2 = line3;
            String string = line3 = st.hasMoreTokens() ? st.nextToken() : null;
            if (!"\n".equals(line3) && st.hasMoreTokens()) {
                st.nextToken();
            }
            if (!strippedAttribution) {
                if (!outlookQuotedLine) {
                    outlookQuotedLine = this.isOutlookQuotedLine(line1);
                }
                if (this.isQuotedLine(line3)) {
                    if (this.looksLikeAttribution(line1)) {
                        line1 = "> ";
                    } else if (this.looksLikeAttribution(line2)) {
                        line2 = "> ";
                    }
                    strippedAttribution = true;
                }
            }
            if (line1 == null || this.isQuotedLine(line1) || outlookQuotedLine) continue;
            result.append(line1);
            if ("\n".equals(line1)) continue;
            result.append("\n");
        } while (line1 != null || line2 != null || line3 != null);
        return result.toString();
    }

    private boolean looksLikeAttribution(String line) {
        return line != null && (line.endsWith(":") || line.endsWith(":\r"));
    }

    private boolean isQuotedLine(String line) {
        return line != null && (line.startsWith(">") || line.startsWith("|"));
    }

    private boolean isOutlookQuotedLine(String line) {
        if (line != null) {
            for (String message : this.getOutlookQuoteSeparators()) {
                if (line.indexOf(message) == -1) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getOutlookQuoteSeparators() {
        if (this.messages == null) {
            this.messages = new LinkedList();
            BufferedReader reader = null;
            try {
                String message;
                reader = new BufferedReader(new InputStreamReader(ClassLoaderUtils.getResourceAsStream((String)OUTLOOK_QUOTED_FILE, ((Object)((Object)this)).getClass()), "UTF-8"));
                while ((message = reader.readLine()) != null) {
                    this.messages.add(message);
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Error occurred while reading file 'outlook-email.translations'.");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    this.log.error((Object)"Could not close the file 'outlook-email.translations'.");
                }
            }
        }
        return this.messages;
    }

    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

