/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.AbstractMessageHandler;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailUtils;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import org.ofbiz.core.entity.GenericValue;

public class CreateIssueHandler
extends AbstractMessageHandler {
    private static final String KEY_PROJECT = "project";
    private static final String KEY_ISSUETYPE = "issuetype";
    public static final String CC_ASSIGNEE = "ccassignee";
    public static final String CC_WATCHER = "ccwatcher";
    public String projectKey;
    public String issueType;
    public boolean ccAssignee = true;
    public boolean ccWatcher = false;

    public void init(Map params) {
        this.log.debug((Object)("CreateIssueHandler.init(params: " + params + ")"));
        super.init(params);
        if (params.containsKey(KEY_PROJECT)) {
            this.projectKey = (String)params.get(KEY_PROJECT);
        }
        if (params.containsKey(KEY_ISSUETYPE)) {
            this.issueType = (String)params.get(KEY_ISSUETYPE);
        }
        if (params.containsKey(CC_ASSIGNEE)) {
            this.ccAssignee = Boolean.valueOf((String)params.get(CC_ASSIGNEE));
        }
        if (params.containsKey(CC_WATCHER)) {
            this.ccWatcher = Boolean.valueOf((String)params.get(CC_WATCHER));
        }
    }

    public boolean handleMessage(Message message) throws MessagingException {
        this.log.debug((Object)"CreateIssueHandler.handleMessage");
        if (!this.canHandleMessage(message)) {
            return this.deleteEmail;
        }
        try {
            User reporter = this.getReporter(message);
            if (reporter == null) {
                this.log.warn((Object)"Sender is anonymous, no default reporter specified and creating users is set to false (or external user managment is enabled). Message rejected.");
                this.addError(this.getI18nBean().getText("admin.mail.no.default.reporter"));
                return false;
            }
            GenericValue project = this.getProject(message);
            this.log.debug((Object)("Project = " + project));
            if (project == null) {
                this.log.warn((Object)"Cannot handle message as destination project is null");
                this.addError(this.getI18nBean().getText("admin.mail.no.project.configured"));
                return false;
            }
            Project projectObj = this.getProjectManager().getProjectObj(project.getLong("id"));
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            I18nBean i18nHelper = new I18nBean(Locale.ENGLISH);
            this.getIssueCreationHelperBean().validateLicense((ErrorCollection)errorCollection, (I18nHelper)i18nHelper);
            if (errorCollection.hasAnyErrors()) {
                this.log.warn((Object)("Cannot create issue due to invalid license: " + errorCollection.getErrorMessages().toString()));
                this.addError(this.getI18nBean().getText("admin.mail.bad.license", errorCollection.getErrorMessages().toString()));
                return false;
            }
            if (!this.getPermissionManager().hasPermission(11, projectObj, reporter, true)) {
                this.log.warn((Object)("Reporter (" + reporter.getName() + ") does not have permission to create an issue. Message rejected."));
                this.addError(this.getI18nBean().getText("admin.mail.no.create.permission", reporter.getName()));
                return false;
            }
            this.log.debug((Object)("Issue Type Key = = " + this.issueType));
            if (!this.hasValidIssueType()) {
                this.log.warn((Object)"Cannot handle message as Issue Type is null or invalid");
                this.addError(this.getI18nBean().getText("admin.mail.invalid.issue.type"));
                return false;
            }
            String summary = message.getSubject();
            if (!TextUtils.stringSet((String)summary)) {
                this.addError(this.getI18nBean().getText("admin.mail.no.subject"));
                return false;
            }
            if (summary.length() > SummarySystemField.MAX_LEN.intValue()) {
                this.log.warn((Object)("Truncating summary field because it is too long: " + summary));
                summary = summary.substring(0, SummarySystemField.MAX_LEN.intValue() - 3) + "...";
            }
            String priority = null;
            String description = null;
            if (!this.getFieldVisibilityManager().isFieldHiddenInAllSchemes(project.getLong("id"), "priority", Collections.singletonList(this.issueType))) {
                priority = this.getPriority(message);
            }
            if (!this.getFieldVisibilityManager().isFieldHiddenInAllSchemes(project.getLong("id"), "description", Collections.singletonList(this.issueType))) {
                description = this.getDescription(reporter, message);
            }
            MutableIssue issueObject = this.getIssueFactory().getIssue();
            issueObject.setProject(project);
            issueObject.setSummary(summary);
            issueObject.setDescription(description);
            issueObject.setIssueTypeId(this.issueType);
            issueObject.setReporter(reporter);
            User assignee = null;
            if (this.ccAssignee) {
                assignee = CreateIssueHandler.getFirstValidAssignee(message.getAllRecipients(), project);
            }
            if (assignee == null) {
                assignee = this.getAssigneeResolver().getDefaultAssignee((Issue)issueObject, Collections.EMPTY_MAP);
            }
            if (assignee != null) {
                issueObject.setAssignee(assignee);
            }
            issueObject.setPriorityId(priority);
            this.setDefaultSecurityLevel(issueObject);
            HashMap<String, MutableIssue> fields = new HashMap<String, MutableIssue>();
            fields.put("issue", issueObject);
            GenericValue originalIssueGV = this.getIssueManager().getIssue(issueObject.getId());
            List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((Issue)issueObject);
            for (CustomField customField : customFieldObjects) {
                issueObject.setCustomFieldValue(customField, customField.getDefaultValue((Issue)issueObject));
            }
            fields.put("originalissueobject", this.issueFactory.getIssue(originalIssueGV));
            GenericValue issue = this.getIssueManager().createIssue(reporter, fields);
            if (issue != null) {
                this.log.info((Object)("Issue " + issue.get("key") + " created"));
                if (this.ccWatcher) {
                    this.addCcWatchersToIssue(message, issue, reporter);
                }
                this.recordMessageId("ISSUE_CREATED_FROM_EMAIL", message, issue.getLong("id"));
            }
            this.createAttachmentsForMessage(message, issue);
            return true;
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not create issue from message!", (Throwable)e);
            this.addError(this.getI18nBean().getText("admin.mail.unable.to.create.issue"), e);
            return false;
        }
    }

    private IssueCreationHelperBean getIssueCreationHelperBean() {
        return ComponentManager.getComponentInstanceOfType(IssueCreationHelperBean.class);
    }

    PermissionManager getPermissionManager() {
        return ComponentManager.getComponentInstanceOfType(PermissionManager.class);
    }

    FieldVisibilityManager getFieldVisibilityManager() {
        return ComponentManager.getComponentInstanceOfType(FieldVisibilityManager.class);
    }

    AssigneeResolver getAssigneeResolver() {
        return ComponentManager.getComponentInstanceOfType(AssigneeResolver.class);
    }

    IssueManager getIssueManager() {
        return ComponentManager.getComponentInstanceOfType(IssueManager.class);
    }

    IssueFactory getIssueFactory() {
        return ComponentManager.getComponentInstanceOfType(IssueFactory.class);
    }

    public void addCcWatchersToIssue(Message message, GenericValue issue, User reporter) throws MessagingException {
        Collection<User> users = this.getAllUsersFromEmails(message.getAllRecipients());
        users.remove(reporter);
        if (!users.isEmpty()) {
            for (User user : users) {
                this.getWatcherManager().startWatching(user, issue);
            }
        }
    }

    WatcherManager getWatcherManager() {
        return ComponentManager.getComponentInstanceOfType(WatcherManager.class);
    }

    public Collection<User> getAllUsersFromEmails(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<User> users = new ArrayList<User>();
        for (Address address : addresses) {
            User user;
            String emailAddress = this.getEmailAddress(address);
            if (emailAddress == null || (user = UserUtils.getUserByEmail((String)emailAddress)) == null) continue;
            users.add(user);
        }
        return users;
    }

    private String getEmailAddress(Address address) {
        if (address instanceof InternetAddress) {
            InternetAddress internetAddress = (InternetAddress)address;
            return internetAddress.getAddress();
        }
        return null;
    }

    protected GenericValue getProject(Message message) {
        if (this.projectKey == null) {
            this.log.debug((Object)"Project key NOT set. Cannot find project.");
            return null;
        }
        this.log.debug((Object)("Project key = " + this.projectKey));
        return this.getProjectManager().getProjectByKey(this.projectKey.toUpperCase(Locale.getDefault()));
    }

    protected boolean hasValidIssueType() {
        if (this.issueType == null) {
            this.log.debug((Object)"Issue Type NOT set. Cannot find Issue type.");
            return false;
        }
        IssueType issueTypeObject = this.getConstantsManager().getIssueTypeObject(this.issueType);
        if (issueTypeObject == null) {
            this.log.debug((Object)("Issue Type with does not exist with id of " + this.issueType));
            return false;
        }
        this.log.debug((Object)("Issue Type Object = " + issueTypeObject.getName()));
        return true;
    }

    protected ProjectManager getProjectManager() {
        return ComponentManager.getComponentInstanceOfType(ProjectManager.class);
    }

    private String getDescription(User reporter, Message message) throws MessagingException {
        return this.recordFromAddressForAnon(reporter, message, MailUtils.getBody((Message)message));
    }

    private String recordFromAddressForAnon(User reporter, Message message, String description) throws MessagingException {
        if (this.reporteruserName != null && this.reporteruserName.equals(reporter.getName())) {
            description = description + "\n[Created via e-mail ";
            description = message.getFrom() != null && message.getFrom().length > 0 ? description + "received from: " + message.getFrom()[0] + "]" : description + "but could not establish sender's address.]";
        }
        return description;
    }

    private String getPriority(Message message) throws MessagingException {
        String[] xPrioHeaders = message.getHeader("X-Priority");
        if (xPrioHeaders != null && xPrioHeaders.length > 0) {
            String xPrioHeader = xPrioHeaders[0];
            int priorityValue = Integer.parseInt(TextUtils.extractNumber((String)xPrioHeader));
            if (priorityValue == 0) {
                return this.getDefaultSystemPriority();
            }
            Collection priorities = this.getConstantsManager().getPriorityObjects();
            Iterator priorityIt = priorities.iterator();
            int priorityNumber = (int)Math.ceil((double)priorityValue / 5.0 * (double)priorities.size());
            if (priorityNumber > priorities.size()) {
                priorityNumber = priorities.size();
            }
            String priority = null;
            for (int i = 0; i < priorityNumber; ++i) {
                priority = ((Priority)priorityIt.next()).getId();
            }
            return priority;
        }
        return this.getDefaultSystemPriority();
    }

    ConstantsManager getConstantsManager() {
        return ComponentManager.getComponentInstanceOfType(ConstantsManager.class);
    }

    private String getDefaultSystemPriority() {
        Priority defaultPriority = this.getConstantsManager().getDefaultPriorityObject();
        if (defaultPriority == null) {
            this.log.error((Object)"Default priority was null. Using the 'middle' priority.");
            Collection priorities = this.getConstantsManager().getPriorityObjects();
            int times = (int)Math.ceil((double)priorities.size() / 2.0);
            Iterator priorityIt = priorities.iterator();
            for (int i = 0; i < times; ++i) {
                defaultPriority = (Priority)priorityIt.next();
            }
        }
        if (defaultPriority == null) {
            throw new RuntimeException("Default priority not found");
        }
        return defaultPriority.getId();
    }

    public static User getFirstValidAssignee(Address[] addresses, GenericValue project) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        for (Address address : addresses) {
            InternetAddress email;
            User validUser;
            if (!(address instanceof InternetAddress) || (validUser = UserUtils.getUserByEmail((String)(email = (InternetAddress)address).getAddress())) == null || !ComponentManager.getComponentInstanceOfType(PermissionManager.class).hasPermission(17, project, validUser)) continue;
            return validUser;
        }
        return null;
    }

    private void setDefaultSecurityLevel(MutableIssue issue) throws Exception {
        Long levelId;
        GenericValue project = issue.getProject();
        if (project != null && (levelId = this.getIssueSecurityLevelManager().getSchemeDefaultSecurityLevel(project)) != null) {
            issue.setSecurityLevel(this.getIssueSecurityLevelManager().getIssueSecurity(levelId));
        }
    }

    IssueSecurityLevelManager getIssueSecurityLevelManager() {
        return ComponentManager.getComponentInstanceOfType(IssueSecurityLevelManager.class);
    }

    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && MailUtils.isPartAttachment((Part)part);
    }

    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && MailUtils.isPartAttachment((Part)part);
    }
}

