/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import webwork.action.Action;

public class XsrfFailureException
extends RuntimeException {
    private final Action action;
    private final XsrfCheckResult checkResult;
    private final boolean sessionExpired;
    private final String requestURL;
    private final String requestMethod;
    private final Set<Map.Entry<String, List<String>>> parameters;

    public XsrfFailureException(Action action, HttpServletRequest request, XsrfCheckResult checkResult, boolean sessionExpired) {
        this.action = action;
        this.checkResult = checkResult;
        this.sessionExpired = sessionExpired;
        this.requestURL = request.getRequestURL().toString();
        this.requestMethod = request.getMethod();
        HashMap<String, List<String>> allParams = new HashMap<String, List<String>>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(name);
            allParams.put(name, Arrays.asList(values));
        }
        Comparator<Map.Entry<String, List<String>>> biggestValueFirst = new Comparator<Map.Entry<String, List<String>>>(){

            @Override
            public int compare(Map.Entry<String, List<String>> entry1, Map.Entry<String, List<String>> entry2) {
                int valLen1 = 0;
                int valLen2 = 0;
                if (entry1.getValue() != null) {
                    for (String s : entry1.getValue()) {
                        valLen1 += s != null ? s.length() : 0;
                    }
                }
                if (entry2.getValue() != null) {
                    for (String s : entry2.getValue()) {
                        valLen2 += s != null ? s.length() : 0;
                    }
                }
                if (valLen1 == valLen2) {
                    return entry1.getKey().compareTo(entry2.getKey());
                }
                return valLen2 - valLen1;
            }
        };
        this.parameters = ImmutableSortedSet.copyOf((Comparator)biggestValueFirst, allParams.entrySet());
    }

    public Action getAction() {
        return this.action;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public Set<Map.Entry<String, List<String>>> getRequestParameters() {
        return this.parameters;
    }

    public XsrfCheckResult getCheckResult() {
        return this.checkResult;
    }

    public boolean isSessionExpired() {
        return this.sessionExpired;
    }
}

