/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GroupSelectorUtils
implements Startable {
    private static final Logger log = Logger.getLogger(GroupSelectorUtils.class);
    private final GenericDelegator genericDelegator;
    private final FieldManager fieldManager;
    private final UserUtil userUtil;
    private final EventPublisher eventPublisher;
    private final GroupManager groupManager;
    private static final String GROUP_DISPLAY_NAME = "jira.group.displayname";
    private MultiMap displayNameCache;

    public GroupSelectorUtils(GenericDelegator genericDelegator, FieldManager fieldManager, UserUtil userUtil, EventPublisher eventPublisher, GroupManager groupManager) {
        this.genericDelegator = genericDelegator;
        this.fieldManager = fieldManager;
        this.userUtil = userUtil;
        this.eventPublisher = eventPublisher;
        this.groupManager = groupManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        if (this.displayNameCache != null) {
            this.displayNameCache.clear();
        }
    }

    public Set getUsers(Issue issue, String customFieldId) {
        UtilTimerStack.push((String)"GroupCF.getUsers");
        if (issue == null) {
            return Collections.EMPTY_SET;
        }
        FieldManager fieldManager = ComponentManager.getInstance().getFieldManager();
        CustomField field = fieldManager.getCustomField(customFieldId);
        if (field == null) {
            throw new IllegalArgumentException("Group Selector permission configured with custom field " + customFieldId + ", but this field does not exist");
        }
        if (!(field.getCustomFieldType() instanceof GroupSelectorField)) {
            throw new IllegalArgumentException("Group Selector permission configured with field " + customFieldId + ", but this is not a type that can select groups");
        }
        Object groupCFValue = field.getValue(issue);
        if (groupCFValue == null) {
            log.debug((Object)("Issue " + issue + " has no value for field " + field));
        }
        Set<Group> groups = this.getGroups(groupCFValue);
        if (log.isDebugEnabled()) {
            if (groupCFValue == null) {
                log.debug((Object)("Issue " + issue + " does not have a value for field " + field));
            } else if (groups.size() == 0) {
                log.debug((Object)("No groups found for group selector value '" + groupCFValue + "' on issue " + issue + ". Perhaps no group is mapped to this name?"));
            } else {
                log.debug((Object)("GroupCF returned users from groups " + this.printGroups(groups)));
            }
        }
        SortedSet users = this.userUtil.getAllUsersInGroups(groups);
        UtilTimerStack.pop((String)"GroupCF.getUsers");
        return users;
    }

    public Set<User> getUsers(Object groupCustomFieldRawValue) {
        if (groupCustomFieldRawValue == null) {
            return Collections.emptySet();
        }
        Set<Group> groups = this.getGroups(groupCustomFieldRawValue);
        return this.userUtil.getAllUsersInGroups(groups);
    }

    public List getCustomFieldsSpecifyingGroups() {
        Set fieldSet;
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            fieldSet = this.fieldManager.getAllAvailableNavigableFields();
        }
        catch (FieldException e) {
            return Collections.EMPTY_LIST;
        }
        for (Field field : fieldSet) {
            CustomField customField;
            if (!this.fieldManager.isCustomField(field) || !((customField = (CustomField)field).getCustomFieldType() instanceof GroupSelectorField)) continue;
            fields.add(field);
        }
        return fields;
    }

    public boolean isUserInCustomFieldGroup(Issue issue, CustomField field, User user) {
        Object cfValue = issue.getCustomFieldValue(field);
        Set<Group> groups = this.getGroups(cfValue);
        for (Group group : groups) {
            if (!this.groupManager.isUserInGroup(user, group)) continue;
            return true;
        }
        return false;
    }

    public Set<Group> getGroups(Object cfValue) {
        if (cfValue == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> groups = null;
        if (cfValue instanceof Group) {
            groups = new HashSet<Group>(1);
            groups.add(cfValue);
        } else if (cfValue instanceof String) {
            groups = new HashSet(1);
            groups.addAll(this.getGroups((String)cfValue));
        } else if (cfValue instanceof Option) {
            groups = new HashSet(1);
            groups.addAll(this.getGroups(((Option)cfValue).getValue()));
        } else if (cfValue instanceof Collection) {
            Collection groupList = (Collection)cfValue;
            groups = new HashSet(groupList.size());
            for (Object groupValue : groupList) {
                if (groupValue instanceof String) {
                    groups.addAll(this.getGroups((String)groupValue));
                    continue;
                }
                if (groupValue instanceof Option) {
                    groups.addAll(this.getGroups(((Option)groupValue).getValue()));
                    continue;
                }
                if (groupValue instanceof Group) {
                    groups.add(groupValue);
                    continue;
                }
                log.error((Object)("Object '" + groupValue + "' is of type " + cfValue.getClass().getName() + " which cannot be converted to a Group. Needs to be a Group object or a String representing group name."));
            }
        } else {
            log.error((Object)("Object '" + cfValue + "' is of type " + cfValue.getClass().getName() + " which cannot be converted to a Group. Needs to be a Group object or a String representing group name."));
        }
        return groups;
    }

    private Set getGroups(String groupStr) {
        Group group = this.groupManager.getGroup(groupStr);
        if (group != null) {
            HashSet<Group> groups = new HashSet<Group>(1);
            groups.add(group);
            return groups;
        }
        try {
            return this.getGroupsFromDisplayName(groupStr);
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error getting group from name '" + groupStr + "': " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    public String printGroups(Collection groups) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext()) {
            Group group = (Group)groupIter.next();
            buf.append(group.getName());
            if (!groupIter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public Set getGroupsFromDisplayName(String groupDisplayName) throws GenericEntityException {
        this.initDisplayNameCache();
        if (this.displayNameCache.get((Object)groupDisplayName) != null) {
            return new HashSet((Collection)this.displayNameCache.get((Object)groupDisplayName));
        }
        log.warn((Object)("No group with name '" + groupDisplayName + "' found"));
        return Collections.EMPTY_SET;
    }

    private synchronized void initDisplayNameCache() throws GenericEntityException {
        if (this.displayNameCache == null) {
            log.debug((Object)"Populating display name cache. This should only happen once");
            Collection groups = this.groupManager.getAllGroups();
            this.displayNameCache = new MultiHashMap(groups.size());
            for (Group group : groups) {
                String displayName = this.getGroupDisplayName(group);
                if (displayName == null) continue;
                this.displayNameCache.put((Object)displayName, (Object)group);
            }
        }
    }

    public final String getGroupDisplayName(Group group) throws GenericEntityException {
        GenericValue groupGV = this.getGroupGV(group);
        PropertySet propSet = OFBizPropertyUtils.getPropertySet(groupGV);
        return propSet.getString(GROUP_DISPLAY_NAME);
    }

    private GenericValue getGroupGV(Group group) throws GenericEntityException {
        List groups = this.genericDelegator.findByAnd("Group", EasyMap.build((Object)"groupName", (Object)group.getName()));
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("The group '" + group.getName() + "' could not be found.");
        }
        return (GenericValue)groups.get(0);
    }

    public boolean updateGroupName(Group group, String oldVal, String newVal) throws GenericEntityException {
        if (newVal == null || newVal.equals(oldVal)) {
            return false;
        }
        log.debug((Object)("Updating group name cache: " + newVal + " -> " + group));
        GenericValue groupGV = this.getGroupGV(group);
        PropertySet propSet = OFBizPropertyUtils.getPropertySet(groupGV);
        propSet.setAsActualType(GROUP_DISPLAY_NAME, (Object)newVal);
        if (this.displayNameCache != null) {
            this.displayNameCache.remove((Object)oldVal, (Object)group);
            this.displayNameCache.put((Object)newVal, (Object)group);
        }
        return true;
    }
}

