/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.AccountNotFoundException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.security.login.PrincipalInSessionPlacer;
import com.atlassian.seraph.auth.AuthenticationContextAwareAuthenticator;
import com.atlassian.seraph.auth.AuthenticationErrorType;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

@AuthenticationContextAwareAuthenticator
public class JiraSeraphAuthenticator
extends DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(JiraSeraphAuthenticator.class);
    private final PrincipalInSessionPlacer principalInSession = new PrincipalInSessionPlacer();

    protected Principal getUser(String username) {
        return this.getCrowdService().getUser(username);
    }

    protected boolean authenticate(Principal user, String password) throws AuthenticatorException {
        try {
            this.crowdServiceAuthenticate(user, password);
            return true;
        }
        catch (AccountNotFoundException e) {
            log.debug((Object)("authenticate : '" + user.getName() + "' does not exist and cannot be authenticated."));
            return false;
        }
        catch (FailedAuthenticationException e) {
            return false;
        }
        catch (CommunicationException ex) {
            throw new AuthenticatorException(AuthenticationErrorType.CommunicationError);
        }
        catch (OperationFailedException ex) {
            log.error((Object)("Error occurred while trying to authenticate user '" + user.getName() + "'."), (Throwable)ex);
            throw new AuthenticatorException(AuthenticationErrorType.UnknownError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crowdServiceAuthenticate(Principal user, String password) throws FailedAuthenticationException {
        Thread currentThread = Thread.currentThread();
        ClassLoader origCCL = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.getCrowdService().authenticate(user.getName(), password);
        }
        finally {
            currentThread.setContextClassLoader(origCCL);
        }
    }

    protected void putPrincipalInSessionContext(HttpServletRequest httpServletRequest, Principal principal) {
        this.principalInSession.putPrincipalInSessionContext(httpServletRequest, principal);
    }

    private CrowdService getCrowdService() {
        return ComponentManager.getComponent(CrowdService.class);
    }
}

