/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.screenshot.applet;

import com.atlassian.jira.screenshot.applet.MultiPartForm;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class ScreenshotApplet
extends JApplet
implements ActionListener {
    public static final String CANCEL_JAVASCRIPT = "window.close();";
    public String ATTACH_JAVASCRIPT;
    private ImageIcon imageIcon;
    private JLabel photographLabel;
    private static final Pattern SELECTED_ISSUE_PATTERN = Pattern.compile("(&|&amp;)?selectedIssueId=[0-9]*");
    private URL postURL;
    private String afterURL;
    private String issueId;
    private String screenshotName;
    private String encoding;
    private String pasteButtonText;
    private String fileNameLabelText;
    private String commentLabelText;
    private String attachButtonText;
    private String cancelButtonText;
    private String commentLevelLabelText;
    private String badAppletConfigurationText;
    private String securityProblemText;
    private String allUsersCommentLevelText;
    private String userAgent;
    private char submitKey;
    private char cancelKey;
    private final transient FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
    private List<String> commentGroupList;
    private List<ProjectRole> commentRoleList;
    private JTextArea comment;
    private JTextField filename;
    public static final String RELOAD_ACTION = "reload";
    public static final String SUBMIT_ACTION = "submit";
    public static final String CANCEL_ACTION = "cancel";
    private JComboBox commentLevelCombo;
    private JLabel errorMessageLabel;
    private String errorMsgFilenameText;
    List<String> headerList;
    private String projectrolesHeaderText;
    private String groupsHeaderText;

    @Override
    public void init() {
        KeyStroke ctrlBackQuote;
        boolean hasProjectRoles;
        JLabel errorLabel;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setOpaque(true);
        contentPane.add((Component)panel, "Center");
        contentPane = panel;
        if (!this.parseParameters()) {
            errorLabel = new JLabel(this.badAppletConfigurationText);
            errorLabel.setHorizontalAlignment(0);
            contentPane.add((Component)errorLabel, "Center");
            return;
        }
        if (!this.isSecurityOk()) {
            errorLabel = new JLabel(this.securityProblemText);
            errorLabel.setHorizontalAlignment(0);
            contentPane.add((Component)errorLabel, "Center");
            return;
        }
        this.errorMessageLabel = new JLabel();
        this.errorMessageLabel.setHorizontalAlignment(0);
        this.errorMessageLabel.setBackground(Color.white);
        this.errorMessageLabel.setForeground(Color.red);
        this.errorMessageLabel.setOpaque(true);
        contentPane.add((Component)this.errorMessageLabel, "North");
        this.headerList = Arrays.asList(this.projectrolesHeaderText, this.groupsHeaderText);
        this.photographLabel = new JLabel();
        this.photographLabel.setHorizontalAlignment(0);
        this.photographLabel.setBackground(Color.white);
        this.photographLabel.setOpaque(true);
        this.photographLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        contentPane.add((Component)new JScrollPane(this.photographLabel), "Center");
        contentPane = this.getContentPane();
        panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setOpaque(true);
        contentPane.add((Component)panel, "South");
        contentPane = panel;
        contentPane.setLayout(new GridBagLayout());
        JPanel reloadPanel = new JPanel();
        reloadPanel.setLayout(new GridBagLayout());
        reloadPanel.setBackground(Color.white);
        reloadPanel.setOpaque(true);
        contentPane.add((Component)reloadPanel, new GBC(0, 0));
        JButton reloadButton = new JButton(this.pasteButtonText);
        reloadButton.setVerticalTextPosition(0);
        reloadButton.setHorizontalTextPosition(2);
        reloadButton.setMnemonic(65487);
        reloadButton.setActionCommand(RELOAD_ACTION);
        reloadButton.addActionListener(this);
        reloadButton.setHorizontalAlignment(2);
        reloadPanel.add((Component)reloadButton, new GBC(0, 0).setFill(0).setInsets(5, 5, 5, 5));
        JPanel textPanel = new JPanel();
        textPanel.setBackground(Color.white);
        textPanel.setOpaque(true);
        textPanel.setLayout(new GridBagLayout());
        contentPane.add((Component)textPanel, new GBC(0, 1).setFill(1).setWeight(1.0, 0.5));
        JTextPane text = new JTextPane();
        text.setBackground(Color.white);
        text.setEditable(false);
        Style style = text.addStyle("right-align", null);
        StyleConstants.setAlignment(style, 2);
        text.setParagraphAttributes(style, false);
        text.repaint();
        text.setFont(new Font("dialog", 1, 12));
        text.setText(this.fileNameLabelText);
        textPanel.add((Component)text, new GBC(0, 0).setAnchor(12).setInsets(5, 5, 5, 5).setFill(2));
        this.filename = new JTextField(this.screenshotName);
        textPanel.add((Component)this.filename, new GBC(1, 0).setFill(2).setInsets(5, 5, 5, 5));
        text = new JTextPane();
        text.setBackground(Color.white);
        text.setEditable(false);
        style = text.addStyle("right-align", null);
        StyleConstants.setAlignment(style, 2);
        text.setParagraphAttributes(style, false);
        text.repaint();
        text.setFont(new Font("dialog", 1, 12));
        text.setText(this.commentLabelText);
        textPanel.add((Component)text, new GBC(0, 2).setAnchor(12).setInsets(5, 5, 5, 5).setFill(2));
        this.comment = new JTextArea(8, 40);
        this.comment.setWrapStyleWord(true);
        this.comment.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.comment, 20, 30);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        textPanel.add((Component)scrollPane, new GBC(1, 2).setFill(1).setInsets(5, 5, 5, 5).setWeight(0.5, 0.5));
        boolean hasGroups = !this.commentGroupList.isEmpty();
        boolean bl = hasProjectRoles = !this.commentRoleList.isEmpty();
        if (hasGroups || hasProjectRoles) {
            JTextPane text2 = new JTextPane();
            text2.setBackground(Color.white);
            text2.setEditable(false);
            Style style2 = text2.addStyle("right-align", null);
            StyleConstants.setAlignment(style2, 2);
            text2.setParagraphAttributes(style2, false);
            text2.repaint();
            text2.setFont(new Font("dialog", 1, 12));
            text2.setText(this.commentLevelLabelText);
            textPanel.add((Component)text2, new GBC(0, 3).setAnchor(12).setInsets(5, 5, 5, 5).setFill(2).setWeight(0.125, 0.0));
        }
        this.commentLevelCombo = new OptionGroupComboBox(this.headerList);
        this.commentLevelCombo.insertItemAt(this.allUsersCommentLevelText, 0);
        this.commentLevelCombo.setSelectedIndex(0);
        this.commentLevelCombo.setRenderer(new OptionGroupListCellRenderer(this.headerList));
        textPanel.add((Component)this.commentLevelCombo, new GBC(1, 3).setAnchor(17).setInsets(5, 5, 5, 5));
        if (hasProjectRoles) {
            this.commentLevelCombo.addItem("Project Roles");
            for (ProjectRole projectRole : this.commentRoleList) {
                this.commentLevelCombo.addItem(projectRole);
            }
        }
        if (hasGroups) {
            this.commentLevelCombo.addItem("Groups");
            for (String string : this.commentGroupList) {
                this.commentLevelCombo.addItem(string);
            }
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setBackground(Color.white);
        buttonPanel.setOpaque(true);
        contentPane.add((Component)buttonPanel, new GBC(0, 2).setAnchor(10).setInsets(5, 5, 5, 5));
        JButton submitButton = new JButton(this.attachButtonText);
        submitButton.setVerticalTextPosition(0);
        submitButton.setHorizontalTextPosition(2);
        submitButton.setActionCommand(SUBMIT_ACTION);
        submitButton.setMnemonic(this.submitKey);
        submitButton.addActionListener(this);
        buttonPanel.add((Component)submitButton, new GBC(0, 0).setInsets(0, 2, 0, 2));
        JButton cancelButton = new JButton(this.cancelButtonText);
        cancelButton.setVerticalTextPosition(0);
        cancelButton.setHorizontalTextPosition(4);
        cancelButton.setActionCommand(CANCEL_ACTION);
        cancelButton.setMnemonic(this.cancelKey);
        cancelButton.addActionListener(this);
        buttonPanel.add((Component)cancelButton, new GBC(1, 0).setInsets(0, 2, 0, 2));
        if (this.isMacOSX()) {
            ctrlBackQuote = KeyStroke.getKeyStroke((int)this.cancelKey, 2);
            panel.registerKeyboardAction(this, CANCEL_ACTION, ctrlBackQuote, 2);
            KeyStroke ctrlS = KeyStroke.getKeyStroke((int)this.submitKey, 2);
            panel.registerKeyboardAction(this, SUBMIT_ACTION, ctrlS, 2);
        } else {
            ctrlBackQuote = KeyStroke.getKeyStroke((int)this.cancelKey, 8);
            panel.registerKeyboardAction(this, CANCEL_ACTION, ctrlBackQuote, 2);
        }
    }

    private boolean parseParameters() {
        String x;
        this.pasteButtonText = this.getParameter("paste.text", "Paste");
        this.fileNameLabelText = this.getParameter("filename.text", "File name: ");
        this.screenshotName = this.getParameter("screenshotname", "screenshot-1");
        this.fileNameLabelText = this.appendLabelEnding(this.fileNameLabelText);
        this.commentLabelText = this.getParameter("comment.text", "Comment: ");
        this.commentLabelText = this.appendLabelEnding(this.commentLabelText);
        this.commentLevelLabelText = this.getParameter("comment.level.text", " Comment Viewable By: ");
        this.commentLevelLabelText = this.appendLabelEnding(this.commentLevelLabelText);
        this.attachButtonText = this.getParameter("attach.text", "Attach");
        this.cancelButtonText = this.getParameter("cancel.text", "Cancel");
        this.badAppletConfigurationText = this.getParameter("badconfiguration.text", "Bad Applet Configuration.");
        this.securityProblemText = this.getParameter("security.text", "Applet security not setup correctly.  You must accept this applet's certificate for it to run.");
        this.allUsersCommentLevelText = this.getParameter("allusers.text", "All Users");
        this.errorMsgFilenameText = this.getParameter("errormsg.filename.text", "ERROR: The filename must not contain the characters: ").trim();
        this.groupsHeaderText = this.getParameter("groups.text", "Groups");
        this.projectrolesHeaderText = this.getParameter("projectroles.text", "Project Roles");
        this.userAgent = this.getParameter("useragent");
        this.submitKey = this.getParameter("submit.access.key", "S").charAt(0);
        this.cancelKey = this.getParameter("cancel.access.key", "`").charAt(0);
        String post = this.getParameter("post");
        if (post == null) {
            return false;
        }
        try {
            URL base = this.getDocumentBase();
            this.postURL = new URL(base, post);
        }
        catch (MalformedURLException e) {
            return false;
        }
        String after = this.getParameter("after");
        if (after == null) {
            return false;
        }
        try {
            URL base = this.getDocumentBase();
            URL url = new URL(base, after);
            this.afterURL = url.toString();
        }
        catch (MalformedURLException e) {
            return false;
        }
        this.issueId = this.getParameter("issue");
        if (this.issueId == null) {
            return false;
        }
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while ((x = this.getParameter("usergroup." + i)) != null) {
            al.add(x);
            ++i;
        }
        al.toArray(new String[al.size()]);
        this.encoding = this.getParameter("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.commentGroupList = this.buildViewableByList("comment.group.name.");
        this.commentRoleList = this.buildProjectRoleList(this.buildViewableByList("comment.role."));
        return true;
    }

    private List<ProjectRole> buildProjectRoleList(List<String> paramList) {
        ArrayList<ProjectRole> roles = new ArrayList<ProjectRole>(paramList.size());
        for (String value : paramList) {
            try {
                roles.add(ProjectRole.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Parameter value '" + value + "' for project role ignored");
            }
            catch (Exception e) {
                System.err.println("Exception caught while creating project role levels: " + e.getMessage());
            }
        }
        return roles;
    }

    private List<String> buildViewableByList(String viewableListKey) {
        String name;
        ArrayList<String> commentList = new ArrayList<String>();
        int i = 0;
        while ((name = this.getParameter(viewableListKey + i)) != null && name.trim().length() != 0) {
            commentList.add("    " + name);
            ++i;
        }
        return commentList;
    }

    private String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String appendLabelEnding(String s) {
        return s.endsWith(" ") ? s : s + (s.endsWith(":") ? " " : ": ");
    }

    private boolean isSecurityOk() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard();
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public void reload() {
        Image image = null;
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (t != null && t.isDataFlavorSupported(new DataFlavor("image/x-java-image; class=java.awt.Image", "Image"))) {
                image = (Image)t.getTransferData(new DataFlavor("image/x-java-image; class=java.awt.Image", "Image"));
            } else if (this.isMacOSX()) {
                image = this.getMacImage(t);
            }
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("Unsupported image flavor: " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException getting clipboard contents: " + e);
            e.printStackTrace();
        }
        if (image == null) {
            this.photographLabel.setIcon(null);
            this.photographLabel.setText("");
            this.photographLabel.setPreferredSize(this.photographLabel.getMinimumSize());
            this.imageIcon = null;
        } else {
            this.imageIcon = new ImageIcon(image);
            this.photographLabel.setIcon(this.imageIcon);
            this.photographLabel.setText(null);
            this.photographLabel.setPreferredSize(this.photographLabel.getMinimumSize());
        }
    }

    private boolean isMacOSX() {
        String osname = System.getProperty("os.name");
        boolean isWin = osname.startsWith("Windows");
        return !isWin && osname.startsWith("Mac");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(RELOAD_ACTION)) {
            this.filename.setBackground(Color.white);
            this.errorMessageLabel.setText("");
            this.reload();
        }
        if (e.getActionCommand().equals(SUBMIT_ACTION)) {
            if (this.imageIcon == null) {
                return;
            }
            if (this.isFilenameValid()) {
                this.postImage();
                this.runJavascript(SUBMIT_ACTION);
            } else {
                this.errorMessageLabel.setText(this.errorMsgFilenameText + "  " + this.fileNameCharacterCheckerUtil.getPrintableInvalidCharacters());
                this.filename.setBackground(Color.red);
            }
        }
        if (e.getActionCommand().equals(CANCEL_ACTION)) {
            this.runJavascript(CANCEL_ACTION);
        }
    }

    private boolean isFilenameValid() {
        return this.fileNameCharacterCheckerUtil.assertFileNameDoesNotContainInvalidChars(this.filename.getText()) == null;
    }

    private void postImage() {
        try {
            BufferedReader in;
            String completeFileName;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedImage image = new BufferedImage(this.imageIcon.getIconWidth(), this.imageIcon.getIconHeight(), 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(this.imageIcon.getImage(), 0, 0, this);
            this.writeJpegImage(os, image);
            MultiPartForm mpf = new MultiPartForm(this.encoding);
            mpf.addPart("id", null, null, this.issueId.getBytes(this.encoding));
            mpf.addPart("comment", null, null, this.comment.getText().getBytes(this.encoding));
            if (!this.commentLevelCombo.getSelectedItem().equals(this.allUsersCommentLevelText)) {
                Object commentLevel = this.commentLevelCombo.getSelectedItem();
                if (commentLevel instanceof ProjectRole) {
                    String roleCommentLevelId = "role:" + ((ProjectRole)commentLevel).getId().trim();
                    mpf.addPart("commentLevel", null, null, roleCommentLevelId.getBytes(this.encoding));
                    System.out.println("roleLevel = " + roleCommentLevelId);
                } else {
                    String groupCommentLevel = "group:" + ((String)commentLevel).trim();
                    System.out.println("groupLevel = " + groupCommentLevel);
                    mpf.addPart("commentLevel", null, null, groupCommentLevel.getBytes(this.encoding));
                }
            }
            if (!(completeFileName = this.filename.getText()).endsWith(".jpg")) {
                completeFileName = completeFileName + ".jpg";
            }
            mpf.addPart("filename.1", completeFileName, "image/jpeg", os.toByteArray());
            byte[] data = mpf.toByteArray();
            System.out.println("Submitting to: " + this.postURL);
            URLConnection connection = this.postURL.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + mpf.getBoundary());
            connection.setRequestProperty("X-Atlassian-Token", "no-check");
            if (this.userAgent == null || this.userAgent.equals("")) {
                System.out.println("WARNING: User-Agent unknown, user will be logged out");
            } else {
                connection.setRequestProperty("User-Agent", this.userAgent);
            }
            OutputStream os2 = connection.getOutputStream();
            os2.write(data);
            os2.close();
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            }
            catch (IOException ex) {
                in = null;
            }
            if (in != null) {
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    System.out.println(inputLine);
                }
                in.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeJpegImage(ByteArrayOutputStream os, BufferedImage bufferedImage) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
        IIOImage ioImage = new IIOImage(bufferedImage, null, null);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(0.9f);
        writer.setOutput(imageOutputStream);
        writer.write(null, ioImage, iwp);
    }

    private String stripSelectedIssue(String url) {
        if (url != null && url.indexOf("selectedIssueId") != -1) {
            return SELECTED_ISSUE_PATTERN.matcher(url).replaceFirst("");
        }
        return url;
    }

    private URL getAfterUrl(String url, String action) throws MalformedURLException {
        try {
            return new URL(this.getCodeBase() + "views/issue/screenshot-redirecter.jsp?afterURL=" + URLEncoder.encode(url, "UTF8") + "&action=" + action);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void runJavascript(String action) {
        try {
            URL url = action.equals(CANCEL_ACTION) ? this.getAfterUrl(this.stripSelectedIssue(this.afterURL), CANCEL_ACTION) : this.getAfterUrl(this.afterURL, SUBMIT_ACTION);
            this.getAppletContext().showDocument(url);
        }
        catch (MalformedURLException e) {
            System.out.println("JavaScript invocation is not supported.");
        }
    }

    Image getMacImage(Transferable t) {
        if (!this.isQTJavaInstalled()) {
            throw new RuntimeException("QuickTime for Java is not installed");
        }
        Image img = null;
        DataFlavor[] d = t.getTransferDataFlavors();
        if (d == null || d.length == 0) {
            return null;
        }
        try {
            Object is = t.getTransferData(d[0]);
            if (is == null || !(is instanceof InputStream)) {
                throw new RuntimeException("Clipboad does not appear to contain an image");
            }
            img = this.getImageFromPictStream((InputStream)is);
        }
        catch (Exception e) {
            // empty catch block
        }
        return img;
    }

    Image getImageFromPictStream(InputStream is) {
        try {
            int retval;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = new byte[512];
            byte[] buf = new byte[4096];
            baos.write(header, 0, 512);
            while ((retval = is.read(buf, 0, 4096)) > 0) {
                baos.write(buf, 0, retval);
            }
            baos.close();
            int size = baos.size();
            if (size <= 0) {
                return null;
            }
            byte[] imgBytes = baos.toByteArray();
            Class<?> c = Class.forName("quicktime.QTSession");
            Method m = c.getMethod("isInitialized", new Class[0]);
            Boolean b = (Boolean)m.invoke(null, new Object[0]);
            if (!b.booleanValue()) {
                m = c.getMethod("open", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            c = Class.forName("quicktime.util.QTHandle");
            Constructor<?> con = c.getConstructor(imgBytes.getClass());
            Object handle = con.newInstance(new Object[]{imgBytes});
            String s = "PICT";
            c = Class.forName("quicktime.util.QTUtils");
            m = c.getMethod("toOSType", "PICT".getClass());
            Integer type = (Integer)m.invoke(null, "PICT");
            c = Class.forName("quicktime.std.image.GraphicsImporter");
            con = c.getConstructor(Integer.TYPE);
            Object importer = con.newInstance(type);
            m = c.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            m.invoke(importer, handle);
            m = c.getMethod("getNaturalBounds", new Class[0]);
            Object rect = m.invoke(importer, new Object[0]);
            c = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            con = c.getConstructor(importer.getClass());
            Object iDrawer = con.newInstance(importer);
            m = rect.getClass().getMethod("getWidth", new Class[0]);
            Integer width = (Integer)m.invoke(rect, new Object[0]);
            m = rect.getClass().getMethod("getHeight", new Class[0]);
            Integer height = (Integer)m.invoke(rect, new Object[0]);
            Dimension d = new Dimension(width, height);
            c = Class.forName("quicktime.app.view.QTImageProducer");
            con = c.getConstructor(iDrawer.getClass(), d.getClass());
            Object producer = con.newInstance(iDrawer, d);
            if (producer instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)producer);
            }
        }
        catch (RuntimeException re) {
            System.out.println("Runtime Exception: " + re.getMessage());
            re.printStackTrace();
            throw re;
        }
        catch (Exception e) {
            System.out.println("QuickTime for Java error: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("QuickTime for java error: " + e);
        }
        return null;
    }

    boolean isQTJavaInstalled() {
        boolean isInstalled;
        try {
            Class.forName("quicktime.QTSession");
            isInstalled = true;
        }
        catch (Exception e) {
            isInstalled = false;
        }
        return isInstalled;
    }

    private static final class OptionGroupComboBox
    extends JComboBox {
        private final List<String> optionGroupHeaders;

        public OptionGroupComboBox(List<String> optionGroupHeaders) {
            this.optionGroupHeaders = optionGroupHeaders;
        }

        public OptionGroupComboBox(List<String> optionGroupHeaders, Object[] objects) {
            super(objects);
            this.optionGroupHeaders = optionGroupHeaders;
        }

        @Override
        public void setSelectedIndex(int anIndex) {
            if (!this.optionGroupHeaders.contains(this.getItemAt(anIndex))) {
                super.setSelectedIndex(anIndex);
            }
        }
    }

    private static final class OptionGroupListCellRenderer
    extends DefaultListCellRenderer {
        private final List<String> optionGroupHeaders;

        public OptionGroupListCellRenderer(List<String> optionGroupHeaders) {
            this.optionGroupHeaders = optionGroupHeaders;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean enabled = !this.optionGroupHeaders.contains(value);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setEnabled(enabled);
            return this;
        }
    }

    private static class ProjectRole {
        private final String id;
        private final String name;

        public static ProjectRole valueOf(String idname) throws IllegalArgumentException {
            int delim = idname.indexOf(124);
            if (delim > 0) {
                return new ProjectRole(idname.substring(0, delim), "    " + idname.substring(delim + 1));
            }
            throw new IllegalArgumentException("Invalid ID and name");
        }

        public ProjectRole(String id, String name) throws IllegalArgumentException {
            if (id == null) {
                throw new IllegalArgumentException("ID can not be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name can not be null");
            }
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class GBC
    extends GridBagConstraints {
        static final long serialVersionUID = 6663429585863688980L;

        public GBC(int gridx, int gridy) {
            this.gridx = gridx;
            this.gridy = gridy;
        }

        public GBC setSpan(int gridwidth, int gridheight) {
            this.gridwidth = gridwidth;
            this.gridheight = gridheight;
            return this;
        }

        public GBC setAnchor(int anchor) {
            this.anchor = anchor;
            return this;
        }

        public GBC setFill(int fill) {
            this.fill = fill;
            return this;
        }

        public GBC setWeight(double weightx, double weighty) {
            this.weightx = weightx;
            this.weighty = weighty;
            return this;
        }

        public GBC setInsets(int distance) {
            this.insets = new Insets(distance, distance, distance, distance);
            return this;
        }

        public GBC setInsets(int top, int left, int bottom, int right) {
            this.insets = new Insets(top, left, bottom, right);
            return this;
        }

        public GBC setIpad(int ipadx, int ipady) {
            this.ipadx = ipadx;
            this.ipady = ipady;
            return this;
        }
    }
}

