/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.project.AssigneeTypes;
import com.atlassian.jira.project.DefaultAssigneeException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractProjectManager
implements ProjectManager {
    private static final Logger log = Logger.getLogger(AbstractProjectManager.class);
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;

    public AbstractProjectManager(UserManager userManager, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
    }

    public GenericValue getProject(GenericValue issue) {
        return this.getProject(issue.getLong("project"));
    }

    public long getNextId(Project project) {
        return this.getNextId(project.getGenericValue());
    }

    public GenericValue getProjectCategoryByName(final String projectCategoryName) throws DataAccessException {
        GenericValue pc = (GenericValue)CollectionUtils.find((Collection)this.getProjectCategories(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                GenericValue category = (GenericValue)object;
                return projectCategoryName.equals(category.getString("name"));
            }
        });
        return pc;
    }

    public ProjectCategory getProjectCategoryObjectByName(String projectCategoryName) throws DataAccessException {
        if (projectCategoryName == null) {
            return null;
        }
        for (ProjectCategory projectCategory : this.getAllProjectCategories()) {
            if (!projectCategoryName.equals(projectCategory.getName())) continue;
            return projectCategory;
        }
        return null;
    }

    public ProjectCategory getProjectCategoryObjectByNameIgnoreCase(String projectCategoryName) throws DataAccessException {
        if (projectCategoryName == null) {
            return null;
        }
        for (ProjectCategory projectCategory : this.getAllProjectCategories()) {
            if (!projectCategoryName.equalsIgnoreCase(projectCategory.getName())) continue;
            return projectCategory;
        }
        return null;
    }

    public GenericValue getProjectCategoryByNameIgnoreCase(final String projectCategoryName) throws DataAccessException {
        GenericValue pc = (GenericValue)CollectionUtils.find((Collection)this.getProjectCategories(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                GenericValue category = (GenericValue)object;
                return projectCategoryName.equalsIgnoreCase(category.getString("name"));
            }
        });
        return pc;
    }

    public boolean isDefaultAssignee(GenericValue project, GenericValue component) {
        long componentAssigneeType;
        if (component != null && 0L != (componentAssigneeType = ComponentUtils.getComponentAssigneeType(component))) {
            return true;
        }
        return this.isDefaultAssignee(project);
    }

    public boolean isDefaultAssignee(GenericValue project) {
        Long projectDefaultAssigneeType = project.getLong("assigneetype");
        return !(projectDefaultAssigneeType == null ? !AssigneeTypes.isAllowUnassigned() && !ComponentUtils.isProjectLeadAssignable(project) : (!ProjectAssigneeTypes.isUnassigned(projectDefaultAssigneeType) || !AssigneeTypes.isAllowUnassigned()) && !ComponentUtils.isProjectLeadAssignable(project));
    }

    public List<GenericValue> convertToProjects(Collection<Long> projectIds) {
        if (projectIds == null || projectIds.isEmpty()) {
            return null;
        }
        ArrayList<GenericValue> projects = new ArrayList<GenericValue>(projectIds.size());
        for (Long id : projectIds) {
            GenericValue project = this.getProject(id);
            if (project == null) continue;
            projects.add(this.getProject(id));
        }
        Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    public List<Project> convertToProjectObjects(Collection<Long> projectIds) {
        if (projectIds == null) {
            return null;
        }
        ArrayList<Project> projects = new ArrayList<Project>(projectIds.size());
        for (Long id : projectIds) {
            Project project = this.getProjectObj(id);
            if (project == null) continue;
            projects.add(project);
        }
        return projects;
    }

    public User getDefaultAssignee(Project project, ProjectComponent component) {
        return this.getDefaultAssignee(project.getGenericValue(), component.getGenericValue());
    }

    public User getDefaultAssignee(Project project, Collection<ProjectComponent> components) throws DefaultAssigneeException {
        User defaultAssignee = this.getConfiguredDefaultAssignee(project, components);
        if (defaultAssignee == null) {
            if (this.applicationProperties.getOption("jira.option.allowunassigned")) {
                return null;
            }
            throw new DefaultAssigneeException("Invalid default assignee for project '" + project.getKey() + "'. Unassigned issues not allowed.");
        }
        return defaultAssignee;
    }

    private User getConfiguredDefaultAssignee(Project project, Collection<ProjectComponent> components) throws DefaultAssigneeException {
        boolean useProjectLead = false;
        boolean useUnassigned = false;
        for (ProjectComponent component : components) {
            long assigneeType = component.getAssigneeType();
            if (assigneeType == 1L) {
                try {
                    return this.getDefaultAssignee(project, component.getLead());
                }
                catch (InvalidAssigneeException ex) {
                    log.warn((Object)("Unable to assign default assignee for " + project.getKey() + " component '" + component.getName() + "'. " + ex.getMessage()));
                    continue;
                }
            }
            if (assigneeType == 2L) {
                useProjectLead = true;
                continue;
            }
            if (assigneeType != 3L) continue;
            useUnassigned = true;
        }
        if (useProjectLead) {
            return this.useProjectLeadAsDefaultAssignee(project);
        }
        if (useUnassigned) {
            return null;
        }
        Long projectAssigneeType = project.getAssigneeType();
        if (projectAssigneeType != null && projectAssigneeType == 3L) {
            return null;
        }
        return this.useProjectLeadAsDefaultAssignee(project);
    }

    private User useProjectLeadAsDefaultAssignee(Project project) {
        try {
            return this.getDefaultAssignee(project, project.getLeadUserName());
        }
        catch (InvalidAssigneeException ex) {
            log.warn((Object)("Unable to assign default assignee for project " + project.getKey() + ". " + ex.getMessage()));
            throw new DefaultAssigneeException(ex.getMessage());
        }
    }

    private User getDefaultAssignee(Project project, String username) throws InvalidAssigneeException {
        if (username == null) {
            throw new InvalidAssigneeException("Lead user not configured.");
        }
        User assignee = this.userManager.getUserObject(username);
        if (assignee == null) {
            throw new InvalidAssigneeException("Cannot find user '" + username + "'.");
        }
        if (AbstractProjectManager.isUserAssignable(project, assignee)) {
            return assignee;
        }
        throw new InvalidAssigneeException("User '" + username + "' does not have assign permission.");
    }

    private static boolean isUserAssignable(Project project, User user) {
        return ComponentAccessor.getPermissionManager().hasPermission(17, project, user);
    }

    public User getDefaultAssignee(GenericValue project, GenericValue component) {
        if (this.isDefaultAssignee(project, component)) {
            Long projectDefaultAssigneeType;
            if (component != null) {
                long componentAssigneeType = ComponentUtils.getComponentAssigneeType(component);
                if (1L == componentAssigneeType) {
                    return this.getUser(component);
                }
                if (2L == componentAssigneeType) {
                    return this.getUser(project);
                }
                if (3L == componentAssigneeType) {
                    return null;
                }
            }
            if ((projectDefaultAssigneeType = project.getLong("assigneetype")) != null ? ProjectAssigneeTypes.isUnassigned(projectDefaultAssigneeType) && AssigneeTypes.isAllowUnassigned() : AssigneeTypes.isAllowUnassigned()) {
                return null;
            }
            if (ComponentUtils.isProjectLeadAssignable(project)) {
                return this.getUser(project);
            }
        }
        throw new DefaultAssigneeException("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
    }

    private User getUser(GenericValue entity) throws DefaultAssigneeException {
        User user = this.userManager.getUserObject(entity.getString("lead"));
        if (user == null) {
            log.error((Object)"Could not retrieve a user.");
            throw new DefaultAssigneeException("Could not retrieve user " + entity.getString("lead"));
        }
        return user;
    }

    public Project createProject(String name, String key, String description, String lead, String url, Long assigneeType) {
        return this.createProject(name, key, description, lead, url, assigneeType, null);
    }

    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType) {
        return this.updateProject(updatedProject, name, description, lead, url, assigneeType, null);
    }

    private class InvalidAssigneeException
    extends Exception {
        public InvalidAssigneeException(String message) {
            super(message);
        }
    }
}

