/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractJiraCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import javax.servlet.http.HttpServletRequest;

public class UserIsProjectAdminCondition
extends AbstractJiraCondition {
    private final PermissionManager permissionManager;

    public UserIsProjectAdminCondition(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean shouldDisplay(User user, JiraHelper jiraHelper) {
        HttpServletRequest request = jiraHelper.getRequest();
        if (request == null) {
            try {
                return this.permissionManager.hasProjects(23, user);
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            Boolean isProjectAdmin = (Boolean)request.getSession().getAttribute("jira.user.project.admin");
            if (isProjectAdmin == null && user != null) {
                isProjectAdmin = this.permissionManager.hasProjects(23, user) ? Boolean.TRUE : Boolean.FALSE;
                request.getSession().setAttribute("jira.user.project.admin", (Object)isProjectAdmin);
            }
            return isProjectAdmin != null && isProjectAdmin != false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

