/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.KeyComparator;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.util.IssueImplAggregateTimeTrackingCalculator;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.plugin.report.impl.AccuracyCalculator;
import com.atlassian.jira.plugin.report.impl.DurationFormatter;
import com.atlassian.jira.plugin.report.impl.DurationFormatterImpl;
import com.atlassian.jira.plugin.report.impl.IssueSubTaskTransformer;
import com.atlassian.jira.plugin.report.impl.MinutesDurationFormatter;
import com.atlassian.jira.plugin.report.impl.ReportIssue;
import com.atlassian.jira.plugin.report.impl.SubTaskFetcher;
import com.atlassian.jira.plugin.report.impl.SubTaskIncludeValuesGenerator;
import com.atlassian.jira.plugin.report.impl.SubTasksEnabledCondition;
import com.atlassian.jira.plugin.report.impl.TimeTrackingSummaryBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.PermissionCheckBean;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.set.ListOrderedSet;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

public class TimeTrackingReport
extends AbstractReport {
    private static final Long LONG_MAX = Long.MAX_VALUE;
    private final Totals totals = new Totals();
    private final VersionManager versionManager;
    private final ApplicationProperties applicationProperties;
    private final ConstantsManager constantsManager;
    private final AccuracyCalculator accuracyCalculator = new AccuracyCalculatorImpl();
    private final SearchProvider searchProvider;
    private final DurationFormatter defaultDurationFormatter;
    private final BuildUtilsInfo buildUtilsInfo;
    private DurationFormatter durationFormatter;
    private TimeTrackingSummaryBean summaryBean;

    TimeTrackingReport(VersionManager versionManager, ApplicationProperties applicationProperties, ConstantsManager constantsManager, DurationFormatter durationFormatter, SearchProvider searchProvider, BuildUtilsInfo buildUtilsInfo) {
        this.versionManager = versionManager;
        this.applicationProperties = applicationProperties;
        this.constantsManager = constantsManager;
        this.durationFormatter = this.defaultDurationFormatter = durationFormatter;
        this.searchProvider = searchProvider;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public TimeTrackingReport(VersionManager versionManager, ApplicationProperties applicationProperties, ConstantsManager constantsManager, JiraDurationUtils jiraDurationUtils, SearchProvider searchProvider, BuildUtilsInfo buildUtilsInfo) {
        this(versionManager, applicationProperties, constantsManager, new DurationFormatterImpl(new I18nBean(), jiraDurationUtils), searchProvider, buildUtilsInfo);
    }

    public boolean showReport() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    Map<String, Object> getParams(ProjectActionSupport action, Map reqParams) throws PermissionException, GenericEntityException, SearchException {
        User remoteUser = action.getLoggedInUser();
        Long projectId = action.getSelectedProject().getLong("id");
        String versionIdString = (String)reqParams.get("versionId");
        Version version = null;
        if (!versionIdString.equals("-1")) {
            Long versionId = new Long(versionIdString);
            version = this.versionManager.getVersion(versionId);
        }
        TextUtils textUtils = new TextUtils();
        String sortingOrder = (String)reqParams.get("sortingOrder");
        String completedFilter = (String)reqParams.get("completedFilter");
        String subtaskInclusion = (String)reqParams.get("subtaskInclusion");
        Collection issues = this.getReportIssues(remoteUser, projectId, new Long(versionIdString), sortingOrder, completedFilter, subtaskInclusion);
        this.summaryBean = new TimeTrackingSummaryBean(issues);
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("report", (Object)this);
        velocityParams.put("action", action);
        velocityParams.put("version", version);
        velocityParams.put("textUtils", textUtils);
        velocityParams.put("issues", issues);
        velocityParams.put("summaryBean", this.summaryBean);
        velocityParams.put("sortingOrder", sortingOrder);
        velocityParams.put("completedFilter", completedFilter);
        velocityParams.put("versionIdString", versionIdString);
        velocityParams.put("constantsManager", this.constantsManager);
        velocityParams.put("remoteUser", remoteUser);
        velocityParams.put("totals", this.totals);
        velocityParams.put("subtasksEnabled", new SubTasksEnabledCondition().isEnabled());
        velocityParams.put("subtaskDescription", SubTaskIncludeValuesGenerator.Options.getDescription(subtaskInclusion, this.getI18nBean()));
        velocityParams.put("permissionCheck", new PermissionCheckBean());
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        DefaultVelocityRequestContextFactory contextFactory = new DefaultVelocityRequestContextFactory(this.applicationProperties);
        String jiraLogo = lookAndFeelBean.getLogoUrl();
        String jiraBaseUrl = contextFactory.getJiraVelocityRequestContext().getBaseUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = jiraBaseUrl + jiraLogo;
        }
        velocityParams.put("jiraLogo", jiraLogo);
        velocityParams.put("jiraLogoWidth", lookAndFeelBean.getLogoWidth());
        velocityParams.put("jiraLogoHeight", lookAndFeelBean.getLogoHeight());
        velocityParams.put("jiraTitle", this.applicationProperties.getString("jira.title"));
        velocityParams.put("topBgColor", lookAndFeelBean.getTopBackgroundColour());
        velocityParams.put("buildInfo", this.buildUtilsInfo.getBuildInformation());
        velocityParams.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        velocityParams.put("createDate", new Date());
        velocityParams.put("jiraBaseUrl", jiraBaseUrl);
        return velocityParams;
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        this.durationFormatter = this.defaultDurationFormatter;
        return this.descriptor.getHtml("view", this.getParams(action, reqParams));
    }

    public String generateReportExcel(ProjectActionSupport action, Map reqParams) throws Exception {
        StringBuffer contentDispositionValue = new StringBuffer(50);
        contentDispositionValue.append("attachment;filename=\"");
        contentDispositionValue.append(this.getDescriptor().getName()).append(".xls\";");
        HttpServletResponse response = ActionContext.getResponse();
        response.addHeader("content-disposition", contentDispositionValue.toString());
        this.durationFormatter = new MinutesDurationFormatter();
        return this.descriptor.getHtml("excel", this.getParams(action, reqParams));
    }

    public boolean isExcelViewSupported() {
        return true;
    }

    public void validate(ProjectActionSupport action, Map params) {
        super.validate(action, params);
        String sortingOrder = (String)params.get("sortingOrder");
        String completedFilter = (String)params.get("completedFilter");
        String versionId = (String)params.get("versionId");
        if (sortingOrder == null || !sortingOrder.equalsIgnoreCase("most") && !sortingOrder.equalsIgnoreCase("least")) {
            action.addError("sortingOrder", this.getI18nBean().getText("admin.errors.timetracking.invalid.sorting.order"));
        }
        if (completedFilter == null || !completedFilter.equalsIgnoreCase("incomplete") && !completedFilter.equalsIgnoreCase("all")) {
            action.addError("completedFilter", this.getI18nBean().getText("admin.errors.timetracking.invalid.filter"));
        }
        try {
            Project project = action.getSelectedProjectObject();
            if (project == null) {
                action.addErrorMessage(this.getI18nBean().getText("admin.errors.timetracking.no.project"));
                return;
            }
            if (versionId == null || versionId.equals("-2") || versionId.equals("-3") || !versionId.equals("-1") && !this.getProjectVersionIds(project).contains(versionId)) {
                action.addError("versionId", this.getI18nBean().getText("admin.errors.timetracking.no.version"));
            }
        }
        catch (Exception e) {
            action.addErrorMessage(this.getI18nBean().getText("admin.errors.timetracking.versions.error"));
        }
    }

    public Collection<String> getProjectVersionIds(Project project) {
        ArrayList<String> versionIds = new ArrayList<String>();
        for (Version version : this.versionManager.getVersions(project.getId())) {
            versionIds.add(version.getId().toString());
        }
        return versionIds;
    }

    Collection getReportIssues(User user, Long projectId, Long versionId, String sortingOrder, String completedFilter, String subtaskInclusion) throws SearchException {
        Set issuesFound = this.searchIssues(user, projectId, versionId, sortingOrder, subtaskInclusion);
        Predicate reportIssueFilter = this.getCompletionFilter(completedFilter);
        Set transformedIssues = new IssueSubTaskTransformer(reportIssueFilter).getIssues(issuesFound);
        Comparator completionComparator = this.getCompletionComparator(sortingOrder);
        return new Processor(this.durationFormatter, this.accuracyCalculator, completionComparator, reportIssueFilter).getDecoratedIssues(transformedIssues);
    }

    private Predicate getCompletionFilter(String completedFilter) {
        Predicate reportIssueFilter = completedFilter.equals("incomplete") ? new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof ReportIssue) {
                    return !((ReportIssue)object).isAggregateComplete();
                }
                Issue issue = (Issue)object;
                return issue.getEstimate() != null && issue.getEstimate() != 0L;
            }
        } : PredicateUtils.truePredicate();
        return reportIssueFilter;
    }

    private Comparator getCompletionComparator(String sortingOrder) {
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ReportIssue reportIssue1 = (ReportIssue)arg0;
                ReportIssue reportIssue2 = (ReportIssue)arg1;
                int result = reportIssue1.getAggregateRemainingEstimateLong(LONG_MAX).compareTo(reportIssue2.getAggregateRemainingEstimateLong(LONG_MAX));
                if (result == 0) {
                    result = reportIssue2.getAggregateRemainingEstimateLong(LONG_MAX).compareTo(reportIssue1.getAggregateRemainingEstimateLong(LONG_MAX));
                }
                if (result == 0) {
                    return KeyComparator.COMPARATOR.compare(reportIssue1.getIssue().getKey(), reportIssue2.getIssue().getKey());
                }
                return result;
            }
        };
        if (sortingOrder.equals("most")) {
            return comparator;
        }
        return new ReverseComparator(comparator);
    }

    private Set searchIssues(User user, Long projectId, Long versionId, String sortingOrder, String subtaskInclusion) throws SearchException {
        Query parentQuery = this.getSearchForParents(projectId, versionId, sortingOrder);
        SearchResults parentSearchResults = this.searchProvider.search(parentQuery, user, new PagerFilter(Integer.MAX_VALUE));
        ListOrderedSet result = new ListOrderedSet();
        List parentIssues = parentSearchResults.getIssues();
        result.addAll(parentIssues);
        List<Issue> subtasks = new SubTaskFetcher(this.searchProvider).getSubTasks(user, parentIssues, subtaskInclusion, false);
        result.addAll(subtasks);
        return result;
    }

    private Query getSearchForParents(Long projectId, Long versionId, String sortingOrder) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder builder = queryBuilder.where().project(new Long[]{projectId});
        if (versionId != null) {
            if ("-1".equals(versionId.toString())) {
                builder.and().fixVersionIsEmpty();
            } else {
                builder.and().fixVersion().eq(versionId);
            }
        }
        if (sortingOrder.equals("most")) {
            queryBuilder.orderBy().currentEstimate(SortOrder.ASC);
        } else {
            queryBuilder.orderBy().currentEstimate(SortOrder.DESC);
        }
        return queryBuilder.buildQuery();
    }

    public int getCompletionPercentage() {
        return (int)((float)this.summaryBean.getTimeSpent() / (float)(this.summaryBean.getTimeSpent() + this.summaryBean.getRemainingEstimate()) * 100.0f);
    }

    public int getAccuracyPercentage() {
        return AccuracyCalculator.Percentage.calculate(this.summaryBean.getOriginalEstimate(), this.summaryBean.getTimeSpent(), this.summaryBean.getRemainingEstimate());
    }

    Totals getTotals() {
        return this.totals;
    }

    private I18nHelper getI18nBean() {
        return this.descriptor.getI18nBean();
    }

    DurationFormatter getDurationFormatter() {
        return this.durationFormatter;
    }

    public class Totals {
        public String getOriginalEstimate() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getOriginalEstimate()));
        }

        public String getTimeSpent() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getTimeSpent()));
        }

        public String getRemainingEstimate() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate()));
        }

        public String getAccuracyNice() {
            return TimeTrackingReport.this.accuracyCalculator.calculateAndFormatAccuracy(new Long(TimeTrackingReport.this.summaryBean.getOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getTimeSpent()));
        }

        public String getAccuracy() {
            Long accuracy = TimeTrackingReport.this.accuracyCalculator.calculateAccuracy(new Long(TimeTrackingReport.this.summaryBean.getOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getTimeSpent()));
            return TimeTrackingReport.this.durationFormatter.format(accuracy);
        }

        public String getAccuracyPercentage() {
            return "" + AccuracyCalculator.Percentage.calculate(TimeTrackingReport.this.summaryBean.getOriginalEstimate(), TimeTrackingReport.this.summaryBean.getRemainingEstimate(), TimeTrackingReport.this.summaryBean.getTimeSpent());
        }

        public int onSchedule() {
            return TimeTrackingReport.this.accuracyCalculator.onSchedule(new Long(TimeTrackingReport.this.summaryBean.getOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getTimeSpent()));
        }

        public String getTotalCurrentEstimate() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate() + TimeTrackingReport.this.summaryBean.getTimeSpent()));
        }

        public String getAggregateOriginalEstimate() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getAggregateOriginalEstimate()));
        }

        public String getAggregateTimeSpent() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getAggregateTimeSpent()));
        }

        public String getAggregateRemainingEstimate() {
            return TimeTrackingReport.this.durationFormatter.shortFormat(new Long(TimeTrackingReport.this.summaryBean.getAggregateRemainingEstimate()));
        }

        public String getAggregateAccuracyNice() {
            return TimeTrackingReport.this.accuracyCalculator.calculateAndFormatAccuracy(new Long(TimeTrackingReport.this.summaryBean.getAggregateOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getAggregateRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getAggregateTimeSpent()));
        }

        public String getAggregateAccuracy() {
            Long accuracy = TimeTrackingReport.this.accuracyCalculator.calculateAccuracy(new Long(TimeTrackingReport.this.summaryBean.getAggregateOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getAggregateRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getAggregateTimeSpent()));
            return TimeTrackingReport.this.durationFormatter.format(accuracy);
        }

        public String getAggregateAccuracyPercentage() {
            return "" + AccuracyCalculator.Percentage.calculate(TimeTrackingReport.this.summaryBean.getAggregateOriginalEstimate(), TimeTrackingReport.this.summaryBean.getAggregateRemainingEstimate(), TimeTrackingReport.this.summaryBean.getAggregateTimeSpent());
        }

        public int isAggregateOnSchedule() {
            return TimeTrackingReport.this.accuracyCalculator.onSchedule(new Long(TimeTrackingReport.this.summaryBean.getOriginalEstimate()), new Long(TimeTrackingReport.this.summaryBean.getRemainingEstimate()), new Long(TimeTrackingReport.this.summaryBean.getTimeSpent()));
        }
    }

    final class AccuracyCalculatorImpl
    implements AccuracyCalculator {
        AccuracyCalculatorImpl() {
        }

        @Override
        public String calculateAndFormatAccuracy(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
            if (this.accuracyIncalculable(originalEstimate, remainingEstimate, timeSpent)) {
                return TimeTrackingReport.this.getI18nBean().getText("viewissue.timetracking.unknown");
            }
            Long accuracy = this.getAccuracy(originalEstimate, remainingEstimate, timeSpent);
            return TimeTrackingReport.this.durationFormatter.shortFormat(accuracy);
        }

        @Override
        public Long calculateAccuracy(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
            if (this.accuracyIncalculable(originalEstimate, remainingEstimate, timeSpent)) {
                return null;
            }
            return this.getAccuracy(originalEstimate, remainingEstimate, timeSpent);
        }

        @Override
        public int onSchedule(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
            if (originalEstimate == null || remainingEstimate == null || timeSpent == null) {
                return 0;
            }
            long accuracy = this.getAccuracy(originalEstimate, remainingEstimate, timeSpent);
            return accuracy == 0L ? 0 : (accuracy > 0L ? 1 : -1);
        }

        private Long getAccuracy(long originalEst, long timeEst, long timeSpent) {
            return new Long(originalEst - timeEst - timeSpent);
        }

        private boolean accuracyIncalculable(Long originalEstimate, Long remainingEstimate, Long timeSpent) {
            return originalEstimate == null || remainingEstimate == null || timeSpent == null;
        }
    }

    static class Processor {
        private final DurationFormatter durationFormatter;
        private final AccuracyCalculator accuracyCalculator;
        private final Comparator comparator;
        private final Predicate reportIssueFilter;

        Processor(DurationFormatter durationFormatter, AccuracyCalculator accuracyCalculator, Comparator comparator) {
            this(durationFormatter, accuracyCalculator, comparator, PredicateUtils.truePredicate());
        }

        Processor(DurationFormatter durationFormatter, AccuracyCalculator accuracyCalculator, Comparator comparator, Predicate reportIssueFilter) {
            this.durationFormatter = durationFormatter;
            this.accuracyCalculator = accuracyCalculator;
            this.comparator = comparator;
            this.reportIssueFilter = reportIssueFilter;
        }

        List getDecoratedIssues(Collection issues) {
            IssueImplAggregateTimeTrackingCalculator timeTrackingCalculator = new IssueImplAggregateTimeTrackingCalculator(new IssueImplAggregateTimeTrackingCalculator.PermissionChecker(){

                @Override
                public boolean hasPermission(Issue subTask) {
                    return true;
                }
            });
            ArrayList<ReportIssue> decoratedIssues = new ArrayList<ReportIssue>(issues.size());
            for (Issue issue : issues) {
                ReportIssue reportIssue = new ReportIssue(issue, timeTrackingCalculator, this.durationFormatter, this.accuracyCalculator, this.comparator, this.reportIssueFilter);
                if (!this.reportIssueFilter.evaluate((Object)reportIssue)) continue;
                decoratedIssues.add(reportIssue);
            }
            Collections.sort(decoratedIssues, this.comparator);
            return Collections.unmodifiableList(decoratedIssues);
        }
    }
}

