/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.profile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.plugin.profile.OptionalUserProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class DarkFeaturesUserProfilePanel
implements ViewProfilePanel,
OptionalUserProfilePanel {
    private final JiraAuthenticationContext authenticationContext;
    private ViewProfilePanelModuleDescriptor moduleDescriptor;
    private PermissionManager permissionManager;
    private FeatureManager featureManager;

    public DarkFeaturesUserProfilePanel(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, FeatureManager featureManager) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
    }

    public void init(ViewProfilePanelModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Override
    public boolean showPanel(User profileUser, User currentUser) {
        return profileUser.equals(currentUser);
    }

    public String getHtml(User profileUser) {
        User user = this.authenticationContext.getLoggedInUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        DarkFeatures darkFeatures = this.featureManager.getDarkFeatures();
        ArrayList globalEnabledFeatures = Lists.newArrayList(darkFeatures.getGlobalEnabledFeatureKeys());
        ArrayList userEnabledFeatures = Lists.newArrayList(darkFeatures.getUserEnabledFeatures());
        Collections.sort(globalEnabledFeatures);
        Collections.sort(userEnabledFeatures);
        params.put("textUtils", new TextUtils());
        params.put("isAdmin", this.permissionManager.hasPermission(44, user));
        params.put("globalEnabledFeatures", globalEnabledFeatures);
        params.put("userEnabledFeatures", userEnabledFeatures);
        return this.moduleDescriptor.getHtml("view", params);
    }
}

