/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableTopNavigation;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.web.component.webfragment.SystemNavContextLayoutBean;
import com.atlassian.jira.web.component.webfragment.UserNavContextLayoutBean;
import com.atlassian.jira.web.component.webfragment.WebFragmentWebComponent;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TopNavigationModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<PluggableTopNavigation>
implements TopNavigationModuleDescriptor {
    private static final Logger log = Logger.getLogger(TopNavigationModuleDescriptorImpl.class);
    private static final String VIEW_TEMPLATE = "view";
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final WebResourceManager webResourceManager;
    private final PermissionManager permissionManager;
    private final WebFragmentWebComponent webFragmentWebComponent;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final JiraWebInterfaceManager webInterfaceManager;
    private int order;

    public TopNavigationModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, WebResourceManager webResourceManager, PermissionManager permissionManager, WebFragmentWebComponent webFragmentWebComponent, UserProjectHistoryManager userProjectHistoryManager, ModuleFactory moduleFactory, JiraWebInterfaceManager webInterfaceManager) {
        super(authenticationContext, moduleFactory);
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.webResourceManager = webResourceManager;
        this.permissionManager = permissionManager;
        this.webFragmentWebComponent = webFragmentWebComponent;
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.webInterfaceManager = webInterfaceManager;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    public int getOrder() {
        return this.order;
    }

    public String getTopNavigationHtml(HttpServletRequest request, Map<String, Object> startingParms) {
        Map params = this.createVelocityParams(request, startingParms);
        return this.getHtml(VIEW_TEMPLATE, params);
    }

    private Map createVelocityParams(HttpServletRequest request, Map<String, Object> startingParams) {
        HashMap<String, Object> params = startingParams != null ? new HashMap<String, Object>(startingParams) : new HashMap();
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        params.put("lookAndFeelBean", lookAndFeelBean);
        params.put("topBgColour", lookAndFeelBean.getTopBackgroundColour());
        params.put("menuBgColour", lookAndFeelBean.getMenuBackgroundColour());
        params.put("linkColour", lookAndFeelBean.getTextLinkColour());
        params.put("linkAColour", lookAndFeelBean.getTextActiveLinkColour());
        String jiraLogo = lookAndFeelBean.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = this.webResourceManager.getStaticResourcePrefix() + jiraLogo;
        }
        params.put("jiraLogo", jiraLogo);
        params.put("jiraLogoIsPNG", jiraLogo != null && jiraLogo.endsWith(".png"));
        params.put("jiraLogoWidth", lookAndFeelBean.getLogoWidth());
        params.put("jiraLogoHeight", lookAndFeelBean.getLogoHeight());
        params.put("jiraTitle", this.applicationProperties.getDefaultBackedString("jira.title"));
        try {
            params.put("hasAnyProjects", this.permissionManager.hasProjects(10, this.authenticationContext.getUser()));
            params.put("canCreateIssue", this.permissionManager.hasProjects(11, this.authenticationContext.getUser()));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to find if user has browse project permission.", (Throwable)e);
        }
        params.put("currentUser", this.authenticationContext.getUser());
        params.put("navWebFragment", this.webFragmentWebComponent);
        params.put("webInterfaceManager", this.webInterfaceManager);
        params.put("userNavLayout", new UserNavContextLayoutBean(request));
        params.put("systemNavLayout", new SystemNavContextLayoutBean(request));
        params.put("utilTimerStack", new UtilTimerStack());
        Project selectedProject = this.userProjectHistoryManager.getCurrentProject(10, this.authenticationContext.getUser());
        params.put("selectedProject", selectedProject);
        params.put("quickSearchHelpPath", new HelpUtil().getHelpPath("quicksearch"));
        params.put("jiraHelperNoProject", new JiraHelper(request));
        params.put("jiraHelperWithProject", new JiraHelper(request, selectedProject));
        params.put("helpPath", HelpUtil.getInstance().getHelpPath("default").getUrl());
        params.put("modifierKey", BrowserUtils.getModifierKey());
        params.put("selectSection", request.getAttribute("jira.selected.section"));
        params.put("inAdminMode", request.getAttribute("jira.admin.mode") != null);
        params.put("externalLinkUtil", ExternalLinkUtilImpl.getInstance());
        params.put("textutils", new TextUtils());
        return params;
    }
}

