/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.permission.ProjectLiteralSanitiser;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSingleVersionFunction
extends AbstractJqlFunction
implements ClauseSanitisingJqlFunction {
    protected final IndexInfoResolver<Project> projectIndexInfoResolver;
    private final NameResolver<Project> projectResolver;
    private final PermissionManager permissionManager;

    public AbstractSingleVersionFunction(NameResolver<Project> projectResolver, PermissionManager permissionManager) {
        this.projectIndexInfoResolver = this.createIndexInfoResolver(projectResolver);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.projectResolver = (NameResolver)Assertions.notNull((String)"projectResolver", projectResolver);
    }

    public MessageSet validate(User searcher, FunctionOperand operand, TerminalClause terminalClause) {
        MessageSet messages = new NumberOfArgumentsValidator(1, this.getI18n()).validate(operand);
        if (!messages.hasAnyErrors()) {
            List args = operand.getArgs();
            for (String projectArg : args) {
                List<String> projectIds = this.getFilteredIndexValues(projectArg, false, searcher);
                if (!projectIds.isEmpty()) continue;
                messages.addErrorMessage(this.getI18n().getText("jira.jql.version.function.project.arg.incorrect", projectArg, this.getFunctionName()));
            }
        }
        return messages;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        Version version = null;
        List args = operand.getArgs();
        if (args.size() == 1) {
            List<String> projectIds;
            String projectArg = (String)args.get(0);
            try {
                projectIds = this.getFilteredIndexValues(projectArg, queryCreationContext.isSecurityOverriden(), queryCreationContext.getQueryUser());
            }
            catch (IllegalArgumentException e) {
                return new ArrayList<QueryLiteral>();
            }
            if (projectIds.size() != 1) {
                return new ArrayList<QueryLiteral>();
            }
            String project = projectIds.get(0);
            version = this.getVersionForProject(new Long(project));
        }
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>();
        if (version != null) {
            literals.add(new QueryLiteral((Operand)operand, version.getId()));
        }
        return literals;
    }

    @Override
    public FunctionOperand sanitiseOperand(User searcher, final FunctionOperand operand) {
        List args = operand.getArgs();
        if (args.isEmpty()) {
            return operand;
        }
        List literals = CollectionUtil.transform((Iterable)args, (Function)new Function<String, QueryLiteral>(){

            public QueryLiteral get(String input) {
                return new QueryLiteral((Operand)operand, input);
            }
        });
        LiteralSanitiser.Result result = this.createLiteralSanitiser(searcher).sanitiseLiterals(literals);
        if (!result.isModified()) {
            return operand;
        }
        List newArgs = CollectionUtil.transform(result.getLiterals(), (Function)new Function<QueryLiteral, String>(){

            public String get(QueryLiteral input) {
                return input.asString();
            }
        });
        return new FunctionOperand(operand.getName(), (Collection)newArgs);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.VERSION;
    }

    private List<String> getFilteredIndexValues(String projectArg, final boolean overrideSecurity, final User searcher) {
        ArrayList<String> projectStringIds = new ArrayList<String>(this.projectIndexInfoResolver.getIndexedValues(projectArg));
        if (projectStringIds.size() > 1) {
            throw new IllegalArgumentException("How did we get more than one project resolving from '" + projectArg + "'?");
        }
        Iterator disallowedIds = CollectionUtil.filter(projectStringIds.iterator(), (Predicate)new Predicate<String>(){

            public boolean evaluate(String input) {
                Long id = new Long(input);
                if (!overrideSecurity) {
                    return !AbstractSingleVersionFunction.this.permissionManager.hasPermission(10, (Project)AbstractSingleVersionFunction.this.projectResolver.get(id), searcher);
                }
                return false;
            }
        });
        while (disallowedIds.hasNext()) {
            disallowedIds.next();
            disallowedIds.remove();
        }
        return projectStringIds;
    }

    protected IndexInfoResolver<Project> createIndexInfoResolver(NameResolver<Project> projectResolver) {
        return new ProjectIndexInfoResolver((NameResolver<Project>)((NameResolver)Assertions.notNull((String)"projectResolver", projectResolver)));
    }

    LiteralSanitiser createLiteralSanitiser(User user) {
        return new ProjectLiteralSanitiser(this.projectResolver, this.permissionManager, user);
    }

    protected abstract Version getVersionForProject(Long var1);
}

