/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.multitenant;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.multitenant.PluginsEventPublisher;
import com.atlassian.jira.plugin.JiraHostContainer;
import com.atlassian.jira.plugin.JiraModuleFactory;
import com.atlassian.jira.plugin.JiraOsgiContainerManager;
import com.atlassian.jira.plugin.JiraPluginManager;
import com.atlassian.multitenant.MultiTenantComponentFactory;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.MultiTenantComponentFactoryImpl;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.hostcomponents.PropertyBuilder;
import com.atlassian.plugin.servlet.DefaultServletModuleManager;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiTenantHostComponentProxier {
    private static final List<String> EXCLUDES = Arrays.asList("com.atlassian.multitenant", "com.atlassian.jira.multitenant", JiraPluginManager.class.getName(), JiraHostContainer.class.getName(), JiraModuleFactory.class.getName(), JiraOsgiContainerManager.class.getName(), DefaultServletModuleManager.class.getName(), DefaultPluginEventManager.class.getName());
    private Map<String, MultiTenantComponentMap<Object>> proxyMap = CopyOnWriteMap.builder().newHashMap();
    private final MultiTenantComponentFactory factory;
    private final TenantReference tenantReference;
    private final MultiTenantManager multiTenantManager;
    private final EventPublisher eventPublisher;

    public MultiTenantHostComponentProxier(MultiTenantComponentFactory factory, TenantReference tenantReference, MultiTenantManager multiTenantManager, PluginsEventPublisher eventPublisher) {
        this.factory = factory;
        this.tenantReference = tenantReference;
        this.multiTenantManager = multiTenantManager;
        this.eventPublisher = eventPublisher;
        eventPublisher.register(this);
    }

    public void addToRegistry(List<HostComponentRegistration> registry, ComponentRegistrar registrar) {
        HashMap<String, MultiTenantComponentMap> tmpMap = new HashMap<String, MultiTenantComponentMap>();
        for (HostComponentRegistration registration : registry) {
            String name = (String)registration.getProperties().get("bean-name");
            if (name == null) {
                String genKey = String.valueOf(((Object)Arrays.asList(registration.getMainInterfaces())).hashCode());
                registration.getProperties().put("bean-name", "hostComponent-" + genKey);
            }
            boolean excluded = false;
            for (String exclude : EXCLUDES) {
                if (!registration.getInstance().getClass().getName().startsWith(exclude)) continue;
                if (registrar != null) {
                    this.register(registrar, registration, registration.getInstance());
                }
                excluded = true;
                break;
            }
            if (excluded) continue;
            if (this.proxyMap.containsKey(name)) {
                this.proxyMap.get(name).addInstance(registration.getInstance());
                continue;
            }
            if (registrar == null) {
                throw new IllegalStateException("A new component has been registered for this tenant but there's no registrar to register it with: " + name);
            }
            MultiTenantComponentMap map = this.factory.createComponentMap(null);
            map.addInstance(registration.getInstance());
            tmpMap.put(name, map);
            Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), registration.getMainInterfaceClasses(), (InvocationHandler)new MultiTenantComponentFactoryImpl.MultiTenantAwareInvocationHandler(map, this.tenantReference, this.multiTenantManager));
            this.register(registrar, registration, proxy);
        }
        this.proxyMap.putAll(tmpMap);
    }

    private void register(ComponentRegistrar registrar, HostComponentRegistration registration, Object instance) {
        PropertyBuilder builder = registrar.register(registration.getMainInterfaceClasses()).forInstance(instance);
        Enumeration propKeys = registration.getProperties().keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            builder.withProperty(key, (String)registration.getProperties().get(key));
        }
    }

    @EventListener
    public void destroy(PluginFrameworkShutdownEvent event) {
        for (MultiTenantComponentMap<Object> map : this.proxyMap.values()) {
            map.destroy();
        }
        this.proxyMap.clear();
        this.eventPublisher.unregister((Object)this);
    }
}

