/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.OutlookDate;
import com.opensymphony.util.TextUtils;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

class DefaultLicenseDetails
implements LicenseDetails {
    private static final Logger log = Logger.getLogger(DefaultLicenseDetails.class);
    private static final int MAINTENANCE_WARNING_PERIOD_IN_DAYS = 42;
    private static final long GRACE_PERIOD_IN_MILLIS = 2592000000L;
    private final JiraLicense license;
    private final ApplicationProperties applicationProperties;
    private final ExternalLinkUtil externalLinkUtil;
    private final String licenseString;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18nFactory;
    private final DateTimeFormatter dateTimeFormatter;

    DefaultLicenseDetails(JiraLicense license, String licenseString, ApplicationProperties applicationProperties, ExternalLinkUtil externalLinkUtil, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18nFactory, DateTimeFormatter dateTimeFormatter) {
        this.i18nFactory = i18nFactory;
        this.dateTimeFormatter = dateTimeFormatter;
        this.licenseString = (String)Assertions.notNull((String)"licenseString", (Object)licenseString);
        this.license = (JiraLicense)Assertions.notNull((String)"license", (Object)license);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    private boolean isFullLicense() {
        return LicenseType.COMMERCIAL.equals((Object)this.license.getLicenseType()) && !this.license.isEvaluation();
    }

    public boolean isPersonalLicense() {
        return LicenseType.PERSONAL.equals((Object)this.license.getLicenseType());
    }

    private boolean isEvaluationLicense() {
        return this.license.isEvaluation();
    }

    private boolean isAcademicLicense() {
        return LicenseType.ACADEMIC.equals((Object)this.license.getLicenseType());
    }

    private boolean isNonProfitLicense() {
        return LicenseType.NON_PROFIT.equals((Object)this.license.getLicenseType());
    }

    private boolean isCommunityLicense() {
        return LicenseType.COMMUNITY.equals((Object)this.license.getLicenseType());
    }

    private boolean isOpenSourceLicense() {
        return LicenseType.OPEN_SOURCE.equals((Object)this.license.getLicenseType());
    }

    private boolean isDeveloperLicense() {
        return LicenseType.DEVELOPER.equals((Object)this.license.getLicenseType());
    }

    private boolean isDemonstrationLicense() {
        return LicenseType.DEMONSTRATION.equals((Object)this.license.getLicenseType());
    }

    private boolean isCommercialLicense() {
        return this.isFullLicense() || this.isAcademicLicense() || this.isEvaluationLicense() || LicenseType.HOSTED.equals((Object)this.license.getLicenseType());
    }

    private boolean isSelfRenewable() {
        return this.isCommunityLicense() || this.isOpenSourceLicense() || this.isDeveloperLicense() || this.isPersonalLicense();
    }

    private boolean isNonCommercialNonRenewable() {
        return this.isNonProfitLicense() || this.isDemonstrationLicense() || LicenseType.TESTING.equals((Object)this.license.getLicenseType());
    }

    public boolean isEntitledToSupport() {
        return !this.isNonCommercialNonRenewable() && !this.isPersonalLicense();
    }

    public boolean isLicenseAlmostExpired() {
        if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
            Date expiry = this.getLicenseExpiry();
            return expiry != null && expiry.getTime() - this.getCurrentTime() < 7L * DateUtils.DAY_MILLIS;
        }
        return false;
    }

    public boolean isExpired() {
        if (this.isEvaluationLicense()) {
            return this.license.isExpired();
        }
        if (this.isNewBuildWithOldLicense()) {
            return this.isExtendLicenseExpired();
        }
        return false;
    }

    public String getPurchaseDate(OutlookDate outlookDate) {
        return ((OutlookDate)Assertions.notNull((String)"outlookDate", (Object)outlookDate)).formatDMY(this.license.getPurchaseDate());
    }

    public boolean isEvaluation() {
        return this.license.isEvaluation();
    }

    public boolean isStarter() {
        return LicenseType.STARTER.equals((Object)this.license.getLicenseType());
    }

    public boolean isCommercial() {
        return LicenseType.COMMERCIAL.equals((Object)this.license.getLicenseType());
    }

    public boolean isCommunity() {
        return LicenseType.COMMUNITY.equals((Object)this.license.getLicenseType());
    }

    public boolean isOpenSource() {
        return LicenseType.OPEN_SOURCE.equals((Object)this.license.getLicenseType());
    }

    public boolean isNonProfit() {
        return LicenseType.NON_PROFIT.equals((Object)this.license.getLicenseType());
    }

    public boolean isDemonstration() {
        return LicenseType.DEMONSTRATION.equals((Object)this.license.getLicenseType());
    }

    public boolean isDeveloper() {
        return LicenseType.DEVELOPER.equals((Object)this.license.getLicenseType());
    }

    public String getOrganisation() {
        return this.license.getOrganisation() == null ? "<Unknown>" : this.license.getOrganisation().getName();
    }

    public boolean hasLicenseTooOldForBuildConfirmationBeenDone() {
        return this.applicationProperties.getOption("jira.install.oldlicense.confirmed");
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public boolean isMaintenanceValidForBuildDate(Date currentBuildDate) {
        return this.license.getMaintenanceExpiryDate() == null || this.license.getMaintenanceExpiryDate().compareTo(currentBuildDate) >= 0;
    }

    public String getSupportEntitlementNumber() {
        return this.license.getSupportEntitlementNumber();
    }

    private Date getLicenseExpiry() {
        if (this.isEvaluationLicense()) {
            return this.license.getExpiryDate();
        }
        if (this.isNewBuildWithOldLicense()) {
            return this.getExtendedLicenseExpiry();
        }
        return null;
    }

    private Date getExtendedLicenseExpiry() {
        long installationWithExpiredLicenseDate = Long.parseLong(this.getConfirmedInstallWithOldLicenseTimestamp());
        return new Date(installationWithExpiredLicenseDate + 2592000000L);
    }

    private boolean isNewBuildWithOldLicense() {
        return this.license.getMaintenanceExpiryDate().compareTo(this.getCurrentBuildDate()) < 0 && this.hasLicenseTooOldForBuildConfirmationBeenDone();
    }

    private String getTimeUntilExpiry(I18nHelper i18n) {
        return DateUtils.dateDifference((long)this.getCurrentTime(), (long)this.getLicenseExpiry().getTime(), (long)2L, (ResourceBundle)i18n.getDefaultResourceBundle());
    }

    private boolean isMaintenanceAlmostEnded() {
        return this.license.getNumberOfDaysBeforeMaintenanceExpiry() < 42;
    }

    private boolean isMaintenanceExpired() {
        return this.license.isMaintenanceExpired();
    }

    private Date getMaintenanceExpiryDate() {
        return new Date(this.license.getMaintenanceExpiryDate().getTime());
    }

    private boolean isExtendLicenseExpired() {
        try {
            return System.currentTimeMillis() > this.getExtendedLicenseExpiry().getTime();
        }
        catch (NumberFormatException e) {
            log.debug((Object)"The Confirm Install Timestamp does not exist or is in the wrong format.", (Throwable)e);
            return false;
        }
    }

    private String getConfirmedInstallWithOldLicenseTimestamp() {
        return this.applicationProperties.getString("jira.install.oldlicense.confirmed.timestamp");
    }

    User getConfirmedUser() {
        String userName = this.applicationProperties.getString("jira.install.oldlicense.confirmed.user");
        User user = null;
        if (userName != null && (user = UserUtils.getUser((String)userName)) == null) {
            log.warn((Object)("Could not find user [" + userName + "]"));
        }
        return user;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private String getCurrentVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    Date getCurrentBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    public String getSupportRequestMessage(User user) {
        return this.getSupportRequestMessage(this.i18nFactory.getInstance(user), null);
    }

    public String getSupportRequestMessage(I18nHelper i18n, @Nullable OutlookDate ignored) {
        StringBuffer msg = new StringBuffer();
        if (this.isEntitledToSupport()) {
            if (this.isExpired()) {
                msg.append("<p>").append(i18n.getText("admin.supportrequest.success.description")).append("</p>");
                msg.append("<p>").append(i18n.getText("admin.supportrequest.success.supported.expired")).append("</p>");
                msg.append("<p>- ").append(i18n.getText("admin.supportrequest.atlassian.team")).append("</p>");
            } else {
                String mailTo = this.externalLinkUtil.getProperty("external.link.jira.support.mail.to");
                String mailToUrl = "mailto:" + mailTo;
                msg.append("<p>").append(i18n.getText("admin.supportrequest.success.description")).append("</p>");
                msg.append("<p>").append(i18n.getText("admin.supportrequest.success.supported.next")).append("</p>");
                msg.append("<p>").append(i18n.getText("admin.supportrequest.success.supported.email", "<a href=\"" + mailToUrl + "\">", mailTo, "</a>")).append("</p>");
                msg.append("<p>- ").append(i18n.getText("admin.supportrequest.atlassian.team")).append("</p>");
            }
        } else {
            Link urlDocumentation = new Link("external.link.jira.documentation", this.getCurrentVersion());
            Link urlForums = new Link("external.link.atlassian.forums");
            Link urlPurchaseJira = new Link(this.isPersonalLicense() ? "external.link.jira.personal.site" : "external.link.jira.license.new");
            List urls = EasyList.build((Object)urlDocumentation.getStart(), (Object)urlDocumentation.getEnd(), (Object)urlForums.getStart(), (Object)urlForums.getEnd(), (Object)urlPurchaseJira.getStart(), (Object)urlPurchaseJira.getEnd());
            msg.append("<p>").append(i18n.getText("admin.supportrequest.not.supported", this.license.getDescription())).append("</p>");
            msg.append("<p>").append(i18n.getText("admin.supportrequest.not.supported.links", (Object)urls)).append("</p>");
            msg.append("<p>- ").append(i18n.getText("admin.supportrequest.atlassian.team")).append("</p>");
        }
        return msg.toString();
    }

    public String getMaintenanceEndString(OutlookDate outlookDate) {
        Date end = this.isEvaluationLicense() || this.isNewBuildWithOldLicense() ? this.getLicenseExpiry() : this.getMaintenanceExpiryDate();
        return outlookDate.formatDMY(end);
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.license.isUnlimitedNumberOfUsers();
    }

    public int getMaximumNumberOfUsers() {
        return this.license.getMaximumNumberOfUsers();
    }

    public boolean isLicenseSet() {
        return true;
    }

    public int getLicenseVersion() {
        return this.license.getLicenseVersion();
    }

    public String getDescription() {
        return this.license.getDescription();
    }

    public String getPartnerName() {
        return this.license.getPartner() == null ? null : this.license.getPartner().getName();
    }

    public String getLicenseExpiryStatusMessage(@Nullable User user) {
        return this.getLicenseExpiryStatusMessage(this.i18nFactory.getInstance(user), null);
    }

    public String getLicenseExpiryStatusMessage(I18nHelper i18n, @Nullable OutlookDate outlookDate) {
        String msg;
        DateTimeFormatter dmyFormatter = this.dateTimeFormatter.withLocale(i18n.getLocale()).withStyle(DateTimeStyle.DATE);
        if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
            msg = this.isExpired() ? i18n.getText("admin.license.expired") : i18n.getText("admin.license.expiresin", this.getTimeUntilExpiry(i18n), dmyFormatter.format(this.getLicenseExpiry()));
        } else if (!this.isMaintenanceExpired()) {
            msg = this.isEntitledToSupport() ? i18n.getText("admin.support.available.until", "<b>" + dmyFormatter.format(this.getMaintenanceExpiryDate()) + "</b>") : i18n.getText("admin.upgrades.available.until", "<b>" + dmyFormatter.format(this.getMaintenanceExpiryDate()) + "</b>");
        } else {
            return null;
        }
        return "<br><small>(" + msg + ")</small>";
    }

    public String getBriefMaintenanceStatusMessage(I18nHelper i18n) {
        String msg;
        if (!this.isEntitledToSupport()) {
            msg = i18n.getText("admin.license.maintenance.status.unsupported");
        } else {
            msg = i18n.getText("admin.license.maintenance.status.supported.valid");
            if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
                if (this.isExpired()) {
                    msg = i18n.getText("admin.license.maintenance.status.supported.expired");
                }
            } else if (this.isMaintenanceExpired()) {
                msg = i18n.getText("admin.license.maintenance.status.supported.expired");
            }
        }
        return msg;
    }

    public String getLicenseStatusMessage(@Nullable User user, String delimiter) {
        return this.getLicenseStatusMessage(this.i18nFactory.getInstance(user), null, delimiter);
    }

    public String getLicenseStatusMessage(I18nHelper i18n, @Nullable OutlookDate outlookDate, String delimiter) {
        Link urlRenew = new Link("external.link.jira.license.new");
        Link urlEvalExpired = new Link("external.link.jira.license.expiredeval");
        Link urlSelfRenew = new Link("external.link.jira.license.renew.noncommercial");
        Link urlContact = new Link("external.link.jira.license.renew.contact");
        Link urlWhyRenew = new Link("external.link.jira.license.whyrenew");
        DateTimeFormatter dmyFormatter = this.dateTimeFormatter.withLocale(i18n.getLocale()).withStyle(DateTimeStyle.DATE);
        if (this.isEvaluationLicense()) {
            String licenseExpiry = "<strong>" + TextUtils.htmlEncode((String)dmyFormatter.format(this.getLicenseExpiry())) + "</strong>";
            if (this.isExpired()) {
                StringBuffer sb = new StringBuffer();
                sb.append(i18n.getText("admin.license.evaluation.expired", licenseExpiry));
                sb.append(delimiter);
                sb.append(i18n.getText("admin.license.evaluation.expired.renew", urlEvalExpired.getStart(), urlEvalExpired.getEnd()));
                return sb.toString();
            }
            if (this.isLicenseAlmostExpired()) {
                StringBuffer sb = new StringBuffer();
                sb.append(i18n.getText("admin.license.evaluation.almost.expired", licenseExpiry));
                sb.append(delimiter);
                sb.append(i18n.getText("admin.license.evaluation.almost.expired.renew", urlEvalExpired.getStart(), urlEvalExpired.getEnd()));
                return sb.toString();
            }
            return null;
        }
        if (this.isNewBuildWithOldLicense()) {
            String renewKey;
            String supportAndUpdates;
            String maintenanceEnd = "<strong>" + TextUtils.htmlEncode((String)dmyFormatter.format(this.getMaintenanceExpiryDate())) + "</strong>";
            String extendedDaysLeft = this.getTimeUntilExpiry(i18n);
            User user = this.getConfirmedUser();
            String currentVersion = user != null ? i18n.getText("admin.license.nbol.current.version", this.getCurrentVersion(), user.getDisplayName(), user.getName()) : i18n.getText("admin.license.nbol.current.version.user.unknown", this.getCurrentVersion());
            if (this.isEntitledToSupport()) {
                supportAndUpdates = i18n.getText("admin.license.nbol.support.and.updates", maintenanceEnd);
                renewKey = "admin.license.renew.for.support.and.updates";
            } else {
                supportAndUpdates = i18n.getText("admin.license.nbol.updates.only", maintenanceEnd);
                String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only" : "admin.license.renew.for.deprecated";
            }
            Link renewLink = this.isCommercialLicense() ? urlRenew : (this.isSelfRenewable() ? urlSelfRenew : urlContact);
            String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
            String expired = this.isExpired() ? i18n.getText("admin.license.nbol.evaluation.period.has.expired") : i18n.getText("admin.license.nbol.evaluation.period.will.expire.in", "<strong>" + extendedDaysLeft + "</strong>");
            String whyRenew = i18n.getText("admin.license.why.renew", urlWhyRenew.getStart(), urlWhyRenew.getEnd());
            StringBuffer sb = new StringBuffer();
            sb.append(supportAndUpdates).append(delimiter);
            sb.append(currentVersion).append(delimiter);
            sb.append(expired).append(delimiter);
            sb.append(renew).append(" ");
            sb.append(whyRenew);
            return sb.toString();
        }
        String maintenancePeriodEnd = "<strong>" + TextUtils.htmlEncode((String)dmyFormatter.format(this.getMaintenanceExpiryDate())) + "</strong>";
        if (this.isMaintenanceExpired()) {
            String renewKey;
            String supportAndUpdates;
            if (this.isEntitledToSupport()) {
                supportAndUpdates = i18n.getText("admin.license.support.and.updates.has.ended", maintenancePeriodEnd);
                renewKey = "admin.license.renew.for.support.and.updates";
            } else {
                supportAndUpdates = i18n.getText("admin.license.updates.only.has.ended", maintenancePeriodEnd);
                String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only" : "admin.license.renew.for.deprecated";
            }
            Link renewLink = this.isCommercialLicense() ? urlRenew : (this.isSelfRenewable() ? urlSelfRenew : urlContact);
            String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
            String whyRenew = i18n.getText("admin.license.why.renew", urlWhyRenew.getStart(), urlWhyRenew.getEnd());
            StringBuffer sb = new StringBuffer();
            sb.append(supportAndUpdates).append(delimiter);
            sb.append(renew).append(" ");
            sb.append(whyRenew);
            return sb.toString();
        }
        if (this.isMaintenanceAlmostEnded()) {
            String renewKey;
            String supportAndUpdates;
            if (this.isEntitledToSupport()) {
                supportAndUpdates = i18n.getText("admin.license.support.and.updates.will.end", maintenancePeriodEnd);
                renewKey = "admin.license.renew.for.support.and.updates.after";
            } else {
                supportAndUpdates = i18n.getText("admin.license.updates.only.will.end", maintenancePeriodEnd);
                String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only.after" : "admin.license.renew.for.deprecated.after";
            }
            Link renewLink = this.isCommercialLicense() ? urlRenew : (this.isSelfRenewable() ? urlSelfRenew : urlContact);
            String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
            String whyRenew = i18n.getText("admin.license.why.renew", urlWhyRenew.getStart(), urlWhyRenew.getEnd());
            StringBuffer sb = new StringBuffer();
            sb.append(supportAndUpdates).append(delimiter);
            sb.append(renew).append(" ");
            sb.append(whyRenew);
            return sb.toString();
        }
        return null;
    }

    private class Link {
        private final String key;
        private final String param0;

        private Link(String key) {
            this.key = key;
            this.param0 = null;
        }

        private Link(String key, String param) {
            this.key = key;
            this.param0 = param;
        }

        public String getStart() {
            ExternalLinkUtil linkUtil = DefaultLicenseDetails.this.externalLinkUtil;
            String url = this.param0 == null ? linkUtil.getProperty(this.key) : linkUtil.getProperty(this.key, this.param0);
            return "<a href=\"" + url + "\">";
        }

        public String getEnd() {
            return "</a>";
        }
    }
}

