/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HistoryFieldValueValidator {
    private final SearchHandlerManager searchHandlerManager;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final ChangeHistoryManager changeHistoryManager;
    private final JqlOperandResolver operandResolver;
    private final ChangeHistoryFieldConfigurationManager configurationManager;

    public HistoryFieldValueValidator(SearchHandlerManager searchHandlerManager, JqlChangeItemMapping jqlChangeItemMapping, ChangeHistoryManager changeHistoryManager, JqlOperandResolver operandResolver, ChangeHistoryFieldConfigurationManager configurationManager) {
        this.searchHandlerManager = searchHandlerManager;
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.changeHistoryManager = changeHistoryManager;
        this.operandResolver = operandResolver;
        this.configurationManager = configurationManager;
    }

    private boolean stringValueExists(User searcher, String fieldName, String rawValue) {
        ClauseHandler clauseHandler;
        String valuePrefix = "";
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            ClauseValuesGenerator.Results generatorResults = ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator().getPossibleValues(searcher, this.jqlChangeItemMapping.mapJqlClauseToFieldName(fieldName), "", Integer.MAX_VALUE);
            List list = generatorResults.getResults();
            List possibleValues = Lists.transform((List)list, (Function)new Function<ClauseValuesGenerator.Result, String>(){

                public String apply(ClauseValuesGenerator.Result from) {
                    return from.getValue().toLowerCase();
                }
            });
            if (!possibleValues.contains(rawValue.toLowerCase())) {
                Map possibleValuesMap = this.changeHistoryManager.findAllPossibleValues(this.jqlChangeItemMapping.mapJqlClauseToFieldName(fieldName).toLowerCase());
                return possibleValuesMap.containsKey(rawValue.toLowerCase());
            }
            return possibleValues.contains(rawValue.toLowerCase());
        }
        return false;
    }

    public MessageSet validateValues(User searcher, String fieldName, List<QueryLiteral> rawValues) {
        MessageSetImpl messages = new MessageSetImpl();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.getStringValue() != null) {
                if (this.stringValueExists(searcher, fieldName, rawValue.getStringValue())) continue;
                if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                    continue;
                }
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", fieldName, rawValue.getStringValue()));
                continue;
            }
            if (rawValue.getLongValue() == null || this.configurationManager.supportsIdSearching(fieldName.toLowerCase())) continue;
            if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                continue;
            }
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.clause.not.string", rawValue.getSourceOperand().getName(), fieldName));
        }
        return messages;
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

