/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.List;

public class IssueConstantInfoResolver<T extends IssueConstant>
implements IndexInfoResolver<T> {
    private final NameResolver<T> resolver;

    public IssueConstantInfoResolver(NameResolver<T> resolver) {
        this.resolver = (NameResolver)Assertions.notNull((String)"resolver", resolver);
    }

    public List<String> getIndexedValues(String singleValueOperand) {
        Long valueAsLong;
        Assertions.notNull((String)"singleValueOperand", (Object)singleValueOperand);
        List list = this.resolver.getIdsFromName(singleValueOperand);
        if (list.isEmpty() && (valueAsLong = this.getValueAsLong(singleValueOperand)) != null && this.resolver.idExists(valueAsLong)) {
            return Lists.newArrayList((Object[])new String[]{singleValueOperand});
        }
        return list;
    }

    public List<String> getIndexedValues(Long singleValueOperand) {
        Assertions.notNull((String)"singleValueOperand", (Object)singleValueOperand);
        if (this.resolver.idExists(singleValueOperand)) {
            return Lists.newArrayList((Object[])new String[]{singleValueOperand.toString()});
        }
        return this.resolver.getIdsFromName(singleValueOperand.toString());
    }

    public String getIndexedValue(T indexedObject) {
        Assertions.notNull((String)"indexedObject", indexedObject);
        return indexedObject.getId();
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

