/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.NoOpClauseSanitiser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DefaultClausePermissionHandler
implements ClausePermissionHandler {
    private final ClausePermissionChecker permissionChecker;
    private final ClauseSanitiser sanitiser;

    public DefaultClausePermissionHandler(ClausePermissionChecker permissionChecker) {
        this(permissionChecker, NoOpClauseSanitiser.NOOP_CLAUSE_SANITISER);
    }

    public DefaultClausePermissionHandler(ClausePermissionChecker permissionChecker, ClauseSanitiser sanitiser) {
        this.permissionChecker = (ClausePermissionChecker)Assertions.notNull((String)"permissionChecker", (Object)permissionChecker);
        this.sanitiser = (ClauseSanitiser)Assertions.notNull((String)"sanitiser", (Object)sanitiser);
    }

    public boolean hasPermissionToUseClause(User user) {
        return this.permissionChecker.hasPermissionToUseClause(user);
    }

    public Clause sanitise(User user, TerminalClause clause) {
        return this.sanitiser.sanitise(user, clause);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultClausePermissionHandler)) {
            return false;
        }
        DefaultClausePermissionHandler that = (DefaultClausePermissionHandler)o;
        if (this.permissionChecker != null ? !this.permissionChecker.equals(that.permissionChecker) : that.permissionChecker != null) {
            return false;
        }
        return !(this.sanitiser != null ? !this.sanitiser.equals(that.sanitiser) : that.sanitiser != null);
    }

    public int hashCode() {
        int result = this.sanitiser != null ? this.sanitiser.hashCode() : 0;
        result = 31 * result + (this.permissionChecker != null ? this.permissionChecker.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

