/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.permission.DefaultOperandSanitisingVisitor;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.clause.WasClauseImpl;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

@NonInjectableComponent
public class ClauseSanitisingVisitor
implements ClauseVisitor<Clause> {
    private final SearchHandlerManager searchHandlerManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final User user;

    public ClauseSanitisingVisitor(SearchHandlerManager searchHandlerManager, JqlOperandResolver jqlOperandResolver, User user) {
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.user = user;
    }

    public Clause visit(AndClause andClause) {
        return new AndClause(this.sanitiseChildren((Clause)andClause));
    }

    public Clause visit(NotClause notClause) {
        return new NotClause((Clause)notClause.getSubClause().accept((ClauseVisitor)this));
    }

    public Clause visit(OrClause orClause) {
        return new OrClause(this.sanitiseChildren((Clause)orClause));
    }

    public Clause visit(TerminalClause clause) {
        Collection handlers = this.searchHandlerManager.getClauseHandler(this.user, clause.getName());
        if (handlers.isEmpty()) {
            return clause;
        }
        clause = this.sanitiseOperands(clause);
        LinkedHashSet<Clause> newClauses = new LinkedHashSet<Clause>();
        for (ClauseHandler clauseHandler : handlers) {
            newClauses.add(clauseHandler.getPermissionHandler().sanitise(this.user, clause));
        }
        return newClauses.size() == 1 ? (Clause)newClauses.iterator().next() : new OrClause(newClauses);
    }

    public Clause visit(WasClause clause) {
        Operand sanitisedOperand;
        Operand originalOperand = clause.getOperand();
        if (originalOperand.equals(sanitisedOperand = this.sanitisedOperand(originalOperand))) {
            return clause;
        }
        return new WasClauseImpl(clause.getField(), clause.getOperator(), sanitisedOperand, clause.getPredicate());
    }

    public Clause visit(ChangedClause clause) {
        return clause;
    }

    TerminalClause sanitiseOperands(TerminalClause clause) {
        Operand sanitisedOperand;
        Operand originalOperand = clause.getOperand();
        if (originalOperand.equals(sanitisedOperand = this.sanitisedOperand(originalOperand))) {
            return clause;
        }
        return new TerminalClauseImpl(clause.getName(), clause.getOperator(), sanitisedOperand);
    }

    private Operand sanitisedOperand(Operand originalOperand) {
        DefaultOperandSanitisingVisitor visitor = this.createOperandVisitor(this.user);
        Operand sanitisedOperand = (Operand)originalOperand.accept((OperandVisitor)visitor);
        return sanitisedOperand;
    }

    DefaultOperandSanitisingVisitor createOperandVisitor(User user) {
        return new DefaultOperandSanitisingVisitor(this.jqlOperandResolver, user);
    }

    List<Clause> sanitiseChildren(Clause parentClause) {
        ArrayList<Clause> newClauses = new ArrayList<Clause>(parentClause.getClauses().size());
        for (Clause clause : parentClause.getClauses()) {
            newClauses.add((Clause)clause.accept((ClauseVisitor)this));
        }
        return newClauses;
    }
}

