/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.EmptyOperandHandler;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.MultiValueOperandHandler;
import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operand.SingleValueOperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.List;
import org.apache.log4j.Logger;

@InjectableComponent
public final class DefaultJqlOperandResolver
implements JqlOperandResolver {
    private static final Logger log = Logger.getLogger(DefaultJqlOperandResolver.class);
    private final JqlFunctionHandlerRegistry registry;
    private final I18nHelper.BeanFactory factory;
    private final OperandHandler<EmptyOperand> emptyHandler;
    private final OperandHandler<SingleValueOperand> singleHandler;
    private final OperandHandler<MultiValueOperand> multiHandler;

    public DefaultJqlOperandResolver(JqlFunctionHandlerRegistry registry, I18nHelper.BeanFactory factory) {
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.registry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.emptyHandler = new EmptyOperandHandler();
        this.singleHandler = new SingleValueOperandHandler();
        this.multiHandler = new MultiValueOperandHandler(this);
    }

    DefaultJqlOperandResolver(JqlFunctionHandlerRegistry registry, I18nHelper.BeanFactory factory, OperandHandler<EmptyOperand> emptyHandler, OperandHandler<SingleValueOperand> singleHandler, OperandHandler<MultiValueOperand> multiHandler) {
        this.registry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.emptyHandler = (OperandHandler)Assertions.notNull((String)"emptyHandler", emptyHandler);
        this.singleHandler = (OperandHandler)Assertions.notNull((String)"singleHandler", singleHandler);
        this.multiHandler = (OperandHandler)Assertions.notNull((String)"multiHandler", multiHandler);
    }

    public List<QueryLiteral> getValues(User searcher, Operand operand, TerminalClause terminalClause) {
        return this.getValues(new QueryCreationContextImpl(searcher), operand, terminalClause);
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, Operand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"operand", (Object)operand);
        if (operand instanceof EmptyOperand) {
            return this.emptyHandler.getValues(queryCreationContext, (EmptyOperand)operand, terminalClause);
        }
        if (operand instanceof SingleValueOperand) {
            return this.singleHandler.getValues(queryCreationContext, (SingleValueOperand)operand, terminalClause);
        }
        if (operand instanceof MultiValueOperand) {
            return this.multiHandler.getValues(queryCreationContext, (MultiValueOperand)operand, terminalClause);
        }
        if (operand instanceof FunctionOperand) {
            FunctionOperand funcOperand = (FunctionOperand)operand;
            FunctionOperandHandler handler = this.registry.getOperandHandler(funcOperand);
            if (handler != null) {
                return handler.getValues(queryCreationContext, funcOperand, terminalClause);
            }
            return null;
        }
        log.warn((Object)String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        return null;
    }

    public MessageSet validate(User user, Operand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"operand", (Object)operand);
        if (operand instanceof EmptyOperand) {
            return this.emptyHandler.validate(user, (EmptyOperand)operand, terminalClause);
        }
        if (operand instanceof SingleValueOperand) {
            return this.singleHandler.validate(user, (SingleValueOperand)operand, terminalClause);
        }
        if (operand instanceof MultiValueOperand) {
            return this.multiHandler.validate(user, (MultiValueOperand)operand, terminalClause);
        }
        if (operand instanceof FunctionOperand) {
            FunctionOperand funcOperand = (FunctionOperand)operand;
            FunctionOperandHandler handler = this.registry.getOperandHandler(funcOperand);
            if (handler != null) {
                return handler.validate(user, funcOperand, terminalClause);
            }
            MessageSetImpl messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n(user).getText("jira.jql.operand.illegal.function", operand.getDisplayString()));
            return messageSet;
        }
        log.warn((Object)String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(this.getI18n(user).getText("jira.jql.operand.illegal.operand", operand.getDisplayString()));
        return messageSet;
    }

    public MessageSet validate(User searcher, Operand operand, WasClause clause) {
        return new MessageSetImpl();
    }

    public FunctionOperand sanitiseFunctionOperand(User searcher, FunctionOperand funcOperand) {
        JqlFunction jqlFunction;
        FunctionOperandHandler funcHandler = this.registry.getOperandHandler(funcOperand);
        if (funcHandler != null && (jqlFunction = funcHandler.getJqlFunction()) instanceof ClauseSanitisingJqlFunction) {
            return ((ClauseSanitisingJqlFunction)jqlFunction).sanitiseOperand(searcher, funcOperand);
        }
        return funcOperand;
    }

    public QueryLiteral getSingleValue(User user, Operand operand, TerminalClause clause) {
        List<QueryLiteral> list = this.getValues(user, operand, clause);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("Found more than one value in operand '" + operand + "'; values were: " + list);
        }
        return list.get(0);
    }

    public boolean isEmptyOperand(Operand operand) {
        OperandHandler<?> operandHandler = this.getOperandHandler(operand);
        return operandHandler != null && operandHandler.isEmpty();
    }

    public boolean isFunctionOperand(Operand operand) {
        OperandHandler<?> handler = this.getOperandHandler(operand);
        return handler != null && handler.isFunction();
    }

    public boolean isListOperand(Operand operand) {
        OperandHandler<?> handler = this.getOperandHandler(operand);
        return handler != null && handler.isList();
    }

    public boolean isValidOperand(Operand operand) {
        return this.getOperandHandler(operand) != null;
    }

    private I18nHelper getI18n(User user) {
        return this.factory.getInstance(user);
    }

    private OperandHandler<?> getOperandHandler(Operand operand) {
        Assertions.notNull((String)"operand", (Object)operand);
        if (operand instanceof EmptyOperand) {
            return this.emptyHandler;
        }
        if (operand instanceof SingleValueOperand) {
            return this.singleHandler;
        }
        if (operand instanceof MultiValueOperand) {
            return this.multiHandler;
        }
        if (operand instanceof FunctionOperand) {
            FunctionOperand funcOperand = (FunctionOperand)operand;
            return this.registry.getOperandHandler(funcOperand);
        }
        log.debug((Object)String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        return null;
    }
}

