/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteHistoryStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class OfbizVoteHistoryStore
implements VoteHistoryStore {
    static final String VOTE_HISTORY_ENTITY = "VoteHistory";
    static final String ISSUE = "issue";
    static final String VOTES = "votes";
    static final String TIMESTAMP = "timestamp";
    private OfBizDelegator ofBizDelegator;

    public OfbizVoteHistoryStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public List<VoteHistoryEntry> getHistory(Long issueId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        ArrayList<VoteHistoryEntry> history = new ArrayList<VoteHistoryEntry>();
        for (GenericValue gv : this.ofBizDelegator.findByAnd(VOTE_HISTORY_ENTITY, EasyMap.build((Object)ISSUE, (Object)issueId), Collections.singletonList(TIMESTAMP))) {
            history.add(this.gvToHistoryEntry(gv));
        }
        return history;
    }

    @Override
    public void delete(String issueId) throws DataAccessException {
        Assertions.notNull((String)"issueKey", (Object)issueId);
        this.ofBizDelegator.removeByAnd(VOTE_HISTORY_ENTITY, EasyMap.build((Object)ISSUE, (Object)issueId));
    }

    @Override
    public void add(VoteHistoryEntry entry) throws DataAccessException {
        Assertions.notNull((String)"entry", (Object)entry);
        Assertions.notNull((String)"entry.issueKey", (Object)entry.getIssueId());
        Assertions.notNull((String)"avatar.fileName", (Object)entry.getVotes());
        Assertions.notNull((String)"avatar.contentType", (Object)entry.getTimestamp());
        this.ofBizDelegator.createValue(VOTE_HISTORY_ENTITY, this.getFields(entry));
    }

    private Map getFields(VoteHistoryEntry entry) {
        HashMap<String, Comparable<Long>> fields = new HashMap<String, Comparable<Long>>();
        fields.put(ISSUE, entry.getIssueId());
        fields.put(VOTES, Long.valueOf(entry.getVotes()));
        fields.put(TIMESTAMP, entry.getTimestamp());
        return fields;
    }

    VoteHistoryEntry gvToHistoryEntry(GenericValue gv) {
        return new VoteHistoryEntryImpl(gv.getLong(ISSUE), gv.getTimestamp(TIMESTAMP), gv.getLong(VOTES));
    }
}

