/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroup;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.issue.views.util.SearchRequestHeader;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import webwork.action.Action;

public class DefaultSearchRequestHeader
implements SearchRequestHeader {
    private static final String DESCRIPTION_TEMPLATE_NAME = "descriptionTable";
    private final IssueSearcherManager issueSearcherManager;
    private final ApplicationProperties applicationProperties;
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchSortUtil searchSortUtil;
    private final SearchService searchService;
    private final DateTimeFormatter dateTimeFormatter;

    public DefaultSearchRequestHeader(IssueSearcherManager issueSearcherManager, ApplicationProperties applicationProperties, SearchProvider searchProvider, JiraAuthenticationContext authenticationContext, SearchSortUtil searchSortUtil, SearchService searchService, DateTimeFormatter dateTimeFormatter) {
        this.issueSearcherManager = issueSearcherManager;
        this.applicationProperties = applicationProperties;
        this.searchProvider = searchProvider;
        this.authenticationContext = authenticationContext;
        this.searchSortUtil = searchSortUtil;
        this.searchService = searchService;
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
    }

    @Override
    public String getHeader(SearchRequest searchRequest, PagerFilter pagerFilter, JiraResourcedModuleDescriptor<?> descriptor) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("title", SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getString("jira.title")));
            boolean fitsNavigator = this.isSearchRequestFitsNavigator(searchRequest);
            params.put("isSearchRequestFitsNavigator", fitsNavigator);
            if (fitsNavigator) {
                params.put("searcherDescriptions", this.getSearcherViewHtmlDescriptions(searchRequest));
            } else {
                params.put("searchRequestJqlString", this.getSearchRequestJqlString(searchRequest));
            }
            params.put("searchSortDescriptions", this.getSearchSortDescriptions(searchRequest));
            long searchResultsTotalCount = this.searchProvider.searchCount(searchRequest.getQuery(), this.authenticationContext.getUser());
            params.put("searchResultsTotalCount", Long.valueOf(searchResultsTotalCount).intValue());
            params.put("searchResultsStart", this.getNiceStart(pagerFilter.getStart(), searchResultsTotalCount));
            params.put("searchResultsEnd", Math.min((long)(pagerFilter.getStart() + pagerFilter.getMax()), searchResultsTotalCount));
            params.put("i18n", this.authenticationContext.getI18nHelper());
            params.put("now", this.dateTimeFormatter.format(new Date()));
            VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            params.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getLoggedInUser()));
        }
        catch (SearchException e) {
            throw new DataAccessException((Throwable)e);
        }
        return descriptor.getHtml(DESCRIPTION_TEMPLATE_NAME, params);
    }

    private int getNiceStart(int start, long total) {
        if (total == 0L) {
            return 0;
        }
        return start + 1;
    }

    private Collection<String> getSearchSortDescriptions(SearchRequest searchRequest) {
        return this.searchSortUtil.getSearchSortDescriptions(searchRequest, this.authenticationContext.getI18nHelper(), this.authenticationContext.getLoggedInUser());
    }

    private Collection<String> getSearcherViewHtmlDescriptions(SearchRequest searchRequest) {
        ArrayList<String> descriptions = new ArrayList<String>();
        SearchContext searchContext = this.searchService.getSearchContext(this.authenticationContext.getUser(), searchRequest.getQuery());
        Collection searcherGroups = this.issueSearcherManager.getSearcherGroups(searchContext);
        for (SearcherGroup searcherGroup : searcherGroups) {
            Iterator i$ = searcherGroup.getSearchers().iterator();
            while (i$.hasNext()) {
                IssueSearcher element;
                IssueSearcher issueSearcher = element = (IssueSearcher)i$.next();
                descriptions.add(this.getSearcherViewHtml(issueSearcher, searchRequest));
            }
        }
        return descriptions;
    }

    private boolean isSearchRequestFitsNavigator(SearchRequest searchRequest) {
        return this.searchService.doesQueryFitFilterForm(this.authenticationContext.getUser(), searchRequest != null ? searchRequest.getQuery() : null);
    }

    private String getSearchRequestJqlString(SearchRequest searchRequest) {
        if (searchRequest != null) {
            return this.searchService.getJqlString(searchRequest.getQuery());
        }
        return "";
    }

    private String getSearcherViewHtml(IssueSearcher searcher, SearchRequest searchRequest) {
        SearchRenderer searchRenderer = searcher.getSearchRenderer();
        if (searchRequest != null && searchRenderer.isRelevantForQuery(this.authenticationContext.getUser(), searchRequest.getQuery())) {
            Action action = null;
            Query query = searchRequest.getQuery();
            SearchContext searchContext = this.searchService.getSearchContext(this.authenticationContext.getUser(), query);
            return searchRenderer.getViewHtml(this.authenticationContext.getUser(), searchContext, this.getFieldValuesHolder(this.authenticationContext.getUser(), query, searchContext), new HashMap(), action);
        }
        return "";
    }

    private FieldValuesHolder getFieldValuesHolder(User searcher, Query query, SearchContext searchContext) {
        FieldValuesHolderImpl fieldValuesHolder = new FieldValuesHolderImpl();
        this.populateFieldValuesHolderFromSR(searcher, fieldValuesHolder, query, searchContext);
        return fieldValuesHolder;
    }

    private void populateFieldValuesHolderFromSR(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        Collection searchers = this.issueSearcherManager.getAllSearchers();
        for (IssueSearcher issueSearcher : searchers) {
            issueSearcher.getSearchInputTransformer().populateFromQuery(searcher, fieldValuesHolder, query, searchContext);
        }
    }
}

