/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.AbstractSearchRequestIssueTableView;
import com.atlassian.jira.issue.views.util.SearchRequestHeader;
import com.atlassian.jira.issue.views.util.SearchRequestPreviousView;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.IssueTableWriter;
import com.atlassian.jira.web.component.TableLayoutFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class SearchRequestPrintableView
extends AbstractSearchRequestIssueTableView {
    private final SearchRequestHeader searchRequestHeader;
    private final SearchRequestPreviousView searchRequestPreviousView;
    private final TableLayoutFactory tableLayoutFactory;

    public SearchRequestPrintableView(JiraAuthenticationContext authenticationContext, SearchProvider searchProvider, ApplicationProperties appProperties, SearchRequestHeader searchRequestHeader, SearchRequestPreviousView searchRequestPreviousView, TableLayoutFactory tableLayoutFactory, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil) {
        super(authenticationContext, searchProvider, appProperties, searchRequestViewBodyWriterUtil);
        this.searchRequestHeader = searchRequestHeader;
        this.searchRequestPreviousView = searchRequestPreviousView;
        this.tableLayoutFactory = tableLayoutFactory;
    }

    @Override
    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) {
        Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        params.put("searchRequest", searchRequest);
        params.put("i18n", this.authenticationContext.getI18nHelper());
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        params.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getLoggedInUser()));
        params.put("title", SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getString("jira.title")));
        IssueTableLayoutBean columnLayout = this.tableLayoutFactory.getPrintableLayout(searchRequest, this.authenticationContext.getUser());
        params.put("colCount", columnLayout.getColumns().size());
        try {
            params.put("linkToPrevious", this.searchRequestPreviousView.getLinkToPrevious(searchRequest, (JiraResourcedModuleDescriptor<?>)this.descriptor));
            params.put("searchRequestHeader", this.searchRequestHeader.getHeader(searchRequest, searchRequestParams.getPagerFilter(), (JiraResourcedModuleDescriptor<?>)this.descriptor));
            writer.write(this.descriptor.getHtml("header", params));
            IssueTableWriter issueTableWriter = new IssueTableWebComponent().getHtmlIssueWriter(writer, columnLayout, null, null);
            this.searchRequestViewBodyWriterUtil.writeTableBody(writer, issueTableWriter, searchRequest, searchRequestParams.getPagerFilter());
            writer.write(this.descriptor.getHtml("footer", params));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
    }
}

