/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class AllTabPanel
extends AbstractIssueTabPanel {
    private static final Logger log = Logger.getLogger(AllTabPanel.class);
    private PluginAccessor pluginAccessor;

    public AllTabPanel(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IssueAction> getActions(Issue issue, User remoteUser) {
        ArrayList<IssueAction> allActions = new ArrayList<IssueAction>();
        List tabPanelDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueTabPanelModuleDescriptor.class);
        for (IssueTabPanelModuleDescriptor tabPanelDescriptor : tabPanelDescriptors) {
            IssueTabPanel issueTabPanel = (IssueTabPanel)tabPanelDescriptor.getModule();
            String name = "Getting actions for " + tabPanelDescriptor.getCompleteKey();
            UtilTimerStack.push((String)name);
            try {
                if (issueTabPanel instanceof AllTabPanel || !issueTabPanel.showPanel(issue, remoteUser)) continue;
                allActions.addAll(issueTabPanel.getActions(issue, remoteUser));
            }
            catch (AbstractMethodError ex) {
                log.error((Object)("AbstractMethodError detected for '" + tabPanelDescriptor.getName() + "' when running IssueTabPanel.showPanel(). This likely means the plugin is not compatible with this version of JIRA."));
            }
            finally {
                UtilTimerStack.pop((String)name);
            }
        }
        Iterator iterator = allActions.iterator();
        while (iterator.hasNext()) {
            IssueAction issueAction = (IssueAction)iterator.next();
            if (issueAction.isDisplayActionAllTab()) continue;
            iterator.remove();
        }
        if (allActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.noactions"));
            return Collections.singletonList(action);
        }
        Collections.sort(allActions, IssueActionComparator.COMPARATOR);
        return allActions;
    }

    public boolean showPanel(Issue issue, User remoteUser) {
        return true;
    }
}

