/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueSecuritySchemeManagerImpl
extends AbstractSchemeManager
implements IssueSecuritySchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(IssueSecuritySchemeManagerImpl.class);
    private static final String SCHEME_ENTITY_NAME = "IssueSecurityScheme";
    private static final String ISSUE_SECURITY_ENTITY_NAME = "SchemeIssueSecurities";
    private static final String SCHEME_DESC = "Issue Security";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.security.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.security.default.desc";
    private Map cache;
    private final EventPublisher eventPublisher;
    private AssociationManager associationManager;
    private OfBizDelegator ofBizDelegator;

    public IssueSecuritySchemeManagerImpl(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, EventPublisher eventPublisher, AssociationManager associationManager, OfBizDelegator ofBizDelegator, GroupManager groupManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, ofBizDelegator, groupManager);
        this.eventPublisher = eventPublisher;
        this.associationManager = associationManager;
        this.ofBizDelegator = ofBizDelegator;
        this.cache = Collections.synchronizedMap(new LRUMap(1000));
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return ISSUE_SECURITY_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing issue security scheme cache, had " + this.cache.size() + " entries"));
        }
        this.cache.clear();
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        return this.getEntitiesAndCache(EasyMap.build((Object)"scheme", (Object)scheme.getLong("id")));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId) throws GenericEntityException {
        return this.getEntitiesAndCache(EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"security", (Object)entityTypeId));
    }

    public List<GenericValue> getEntitiesBySecurityLevel(Long securityLevelId) throws GenericEntityException {
        return this.getEntitiesAndCache(EasyMap.build((Object)"security", (Object)securityLevelId));
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.ofBizDelegator.findByAnd(ISSUE_SECURITY_ENTITY_NAME, EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        HashSet<Long> schemeIds = new HashSet<Long>();
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        for (Long schemeId : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)schemeId));
        }
        List schemes = !entityConditions.isEmpty() ? this.ofBizDelegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.EMPTY_LIST) : Collections.emptyList();
        return schemes;
    }

    private List getEntitiesAndCache(Map parameters) throws GenericEntityException {
        List result = (List)this.cache.get(parameters);
        if (result == null) {
            result = this.ofBizDelegator.findByAnd(this.getEntityName(), parameters);
            if (result == null) {
                result = Collections.EMPTY_LIST;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching " + result.size() + " entities for cache key: " + parameters));
            }
            this.cache.put(parameters, result);
        }
        return result;
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long schemeTypeId, String parameter) throws GenericEntityException {
        return this.getEntitiesAndCache(EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"security", (Object)schemeTypeId, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Issue Security scheme IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long schemeTypeId) throws GenericEntityException {
        return this.getEntitiesAndCache(EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"security", (Object)schemeTypeId, (Object)"type", (Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Issue Security Level IDs must be a long value.");
        }
        try {
            GenericValue genericValue = EntityUtils.createValue(ISSUE_SECURITY_ENTITY_NAME, EasyMap.build((Object)"scheme", (Object)(scheme == null ? null : scheme.getLong("id")), (Object)"security", (Object)schemeEntity.getEntityTypeId(), (Object)"type", (Object)schemeEntity.getType(), (Object)"parameter", (Object)schemeEntity.getParameter()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("security"));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue copyScheme(GenericValue scheme) throws GenericEntityException {
        if (scheme != null) {
            try {
                String name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", scheme.getString("name"));
                int j = 2;
                while (this.schemeExists(name)) {
                    name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyxof", String.valueOf(j++), scheme.getString("name"));
                }
                GenericValue newScheme = this.createScheme(name, scheme.getString("description"));
                this.copySecurityLevels(newScheme, scheme);
                GenericValue genericValue = newScheme;
                return genericValue;
            }
            finally {
                this.clearCache();
            }
        }
        return null;
    }

    private void copySecurityLevels(GenericValue scheme, GenericValue oldScheme) throws GenericEntityException {
        List levels = this.ofBizDelegator.findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)oldScheme.getLong("id")));
        for (GenericValue level : levels) {
            GenericValue newLevel = EntityUtils.createValue("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"name", (Object)level.getString("name"), (Object)"description", (Object)level.getString("description")));
            if (level.getLong("id").equals(oldScheme.getLong("defaultlevel"))) {
                scheme.set("defaultlevel", (Object)newLevel.getLong("id"));
                scheme.store();
            }
            List securities = this.ofBizDelegator.findByAnd(this.getEntityName(), EasyMap.build((Object)"scheme", (Object)oldScheme.getLong("id"), (Object)"security", (Object)level.getLong("id")));
            for (GenericValue security : securities) {
                this.createSchemeEntity(scheme, new SchemeEntity(security.getString("type"), security.getString("parameter"), (Object)newLevel.getLong("id")));
            }
        }
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return this.hasPermission(entityType, entity, null);
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue issue, User user, boolean issueCreation) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must NOT be null");
        }
        return this.hasPermission(entityType, issue, user);
    }

    private boolean hasPermission(Long entityType, GenericValue issue, User user) {
        if (entityType == null) {
            return true;
        }
        if (issue == null) {
            throw new IllegalArgumentException("GenericValue passed must NOT be null");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("GenericValue passed must be an Issue and not " + issue.getEntityName());
        }
        GenericValue project = null;
        project = ManagerFactory.getProjectManager().getProject(issue);
        try {
            List schemes = ManagerFactory.getIssueSecuritySchemeManager().getSchemes(project);
            for (GenericValue scheme : schemes) {
                if (scheme == null) continue;
                Collection types = ManagerFactory.getIssueSecurityTypeManager().getTypes().values();
                for (SecurityType type : types) {
                    List<GenericValue> entities = this.getEntities(scheme, type.getType(), entityType);
                    for (GenericValue perm : entities) {
                        if (perm == null || !(user == null ? type.hasPermission(issue, perm.getString("parameter")) : type.hasPermission(issue, perm.getString("parameter"), user, false))) continue;
                        return true;
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Could not retrieve entites from the database", (Throwable)e);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        try {
            GenericValue scheme = this.getScheme(id);
            this.associationManager.removeAssociationsFromSink(scheme);
            scheme.removeRelated("Child" + this.getEntityName());
            scheme.removeRelated("ChildSchemeIssueSecurityLevels");
            scheme.remove();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        try {
            super.deleteEntity(id);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        try {
            boolean bl = super.removeEntities(type, parameter);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }
}

