/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueSecurityLevelManagerImpl
implements IssueSecurityLevelManager,
Startable {
    protected final Logger log = Logger.getLogger(IssueSecurityLevelManagerImpl.class);
    private final ConcurrentMap<Long, Map<Object, GenericValue>> projectSecurityLevels = new ConcurrentHashMap<Long, Map<Object, GenericValue>>();
    private static final Object NULL_USER_KEY = new Object();
    private IssueSecuritySchemeManager issueSecuritySchemeManager;
    private SecurityTypeManager securityTypeManager;
    private ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final EntityEngine entityEngine;

    public IssueSecurityLevelManagerImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager securityTypeManager, ProjectManager projectManager, PermissionManager permissionManager, EventPublisher eventPublisher, EntityEngine entityEngine) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.securityTypeManager = securityTypeManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
        this.entityEngine = entityEngine;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearUsersLevels();
    }

    public List<GenericValue> getSchemeIssueSecurityLevels(Long schemeId) {
        try {
            return CoreFactory.getGenericDelegator().findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)schemeId), EasyList.build((Object)"name"));
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Exception", (Throwable)e);
            return null;
        }
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(long schemeId) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).whereEqual("scheme", schemeId).orderBy("name");
    }

    public GenericValue getIssueSecurity(Long id) {
        try {
            return EntityUtil.getOnly((List)CoreFactory.getGenericDelegator().findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"id", (Object)id)));
        }
        catch (GenericEntityException e) {
            return null;
        }
    }

    public IssueSecurityLevel getSecurityLevel(long id) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).findById(id);
    }

    public boolean schemeIssueSecurityExists(Long id) {
        return this.getIssueSecurity(id) != null;
    }

    public String getIssueSecurityName(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("name");
    }

    public String getIssueSecurityDescription(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("description");
    }

    public List<GenericValue> getUsersSecurityLevels(GenericValue entity, User user) throws GenericEntityException {
        Object userKey = user != null ? user : NULL_USER_KEY;
        GenericValue project = this.getProject(entity);
        if (project != null) {
            Map usersLevels;
            if (this.projectSecurityLevels.containsKey(project.getLong("id")) && (usersLevels = (Map)this.projectSecurityLevels.get(project.getLong("id"))) != null && usersLevels.containsKey(userKey)) {
                List userSecurityLevels = (List)usersLevels.get(userKey);
                if (userSecurityLevels != null) {
                    return Collections.unmodifiableList(userSecurityLevels);
                }
                return null;
            }
            ArrayList<GenericValue> levels = new ArrayList<GenericValue>();
            GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
            if (scheme != null) {
                List securities = this.issueSecuritySchemeManager.getEntities(scheme);
                Map types = this.securityTypeManager.getTypes();
                for (GenericValue security : securities) {
                    GenericValue level;
                    boolean hasPermission;
                    SchemeType type;
                    if (this.levelExists(levels, security.getLong("security")) || (type = (SchemeType)types.get(security.getString("type"))) == null || !(hasPermission = user == null ? type.hasPermission(project, security.getString("parameter")) : type.hasPermission(project, security.getString("parameter"), user, false)) || (level = this.getIssueSecurityLevel(security.getLong("security"))) == null) continue;
                    levels.add(level);
                }
            }
            Collections.sort(levels, new Comparator(){

                public int compare(Object level1, Object level2) {
                    String value1 = ((GenericValue)level1).getString("name");
                    String value2 = ((GenericValue)level2).getString("name");
                    return value1 == null ? (value2 == null ? 0 : 1) : (value2 == null ? -1 : value1.compareTo(value2));
                }
            });
            HashMap usersLevels2 = (HashMap)this.projectSecurityLevels.get(project.getLong("id"));
            if (usersLevels2 == null) {
                usersLevels2 = new HashMap();
            }
            usersLevels2.put((User)userKey, levels);
            this.projectSecurityLevels.putIfAbsent(project.getLong("id"), new ConcurrentHashMap(usersLevels2));
            return Collections.unmodifiableList(levels);
        }
        return null;
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Issue issue, User user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(issue.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Project project, User user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(project.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<GenericValue> getAllUsersSecurityLevels(User user) throws GenericEntityException {
        Collection projectGVs = this.permissionManager.getProjects(10, user);
        HashSet<GenericValue> securityLevels = new HashSet<GenericValue>();
        for (GenericValue projectGV : projectGVs) {
            securityLevels.addAll(this.getUsersSecurityLevels(projectGV, user));
        }
        return securityLevels;
    }

    public Collection<IssueSecurityLevel> getAllSecurityLevelsForUser(User user) {
        Collection projects = this.permissionManager.getProjectObjects(10, user);
        HashSet<IssueSecurityLevel> securityLevels = new HashSet<IssueSecurityLevel>();
        for (Project project : projects) {
            securityLevels.addAll(this.getUsersSecurityLevels(project, user));
        }
        return securityLevels;
    }

    public Collection<GenericValue> getAllSecurityLevels() throws GenericEntityException {
        List schemes = this.issueSecuritySchemeManager.getSchemes();
        LinkedHashSet<GenericValue> allLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getSchemeIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<IssueSecurityLevel> getAllIssueSecurityLevels() {
        List schemes;
        try {
            schemes = this.issueSecuritySchemeManager.getSchemes();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        LinkedHashSet<IssueSecurityLevel> allLevels = new LinkedHashSet<IssueSecurityLevel>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<GenericValue> getUsersSecurityLevelsByName(User user, String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllUsersSecurityLevels(user));
    }

    public Collection<IssueSecurityLevel> getSecurityLevelsForUserByName(User user, String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllSecurityLevelsForUser(user));
    }

    public Collection<GenericValue> getSecurityLevelsByName(String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllSecurityLevels());
    }

    public Collection<IssueSecurityLevel> getIssueSecurityLevelsByName(String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllIssueSecurityLevels());
    }

    private Collection<GenericValue> _getSecurityLevelsByName(final String securityLevelName, Collection<GenericValue> securityLevels) throws GenericEntityException {
        Predicate<GenericValue> namePredicate = new Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return securityLevelName.equalsIgnoreCase(input.getString("name"));
            }
        };
        LinkedHashSet<GenericValue> filteredSecurityLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue levelGV : CollectionUtil.filter(securityLevels, (Predicate)namePredicate)) {
            filteredSecurityLevels.add(levelGV);
        }
        return filteredSecurityLevels;
    }

    private List<IssueSecurityLevel> filterSecurityLevelsByName(String securityLevelName, Collection<IssueSecurityLevel> securityLevels) {
        LinkedList<IssueSecurityLevel> filteredSecurityLevels = new LinkedList<IssueSecurityLevel>();
        for (IssueSecurityLevel issueSecurityLevel : securityLevels) {
            if (!issueSecurityLevel.getName().equals(securityLevelName)) continue;
            filteredSecurityLevels.add(issueSecurityLevel);
        }
        return filteredSecurityLevels;
    }

    private GenericValue getProject(GenericValue entity) {
        if (entity != null) {
            if (entity.getEntityName().equals("Project")) {
                return entity;
            }
            if (entity.getEntityName().equals("Issue")) {
                return this.projectManager.getProject(entity);
            }
        }
        return null;
    }

    private boolean levelExists(List levels, Long id) {
        for (GenericValue level : levels) {
            if (!level.getLong("id").equals(id)) continue;
            return true;
        }
        return false;
    }

    public Long getSchemeDefaultSecurityLevel(GenericValue project) throws GenericEntityException {
        if (project != null) {
            GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
            return scheme == null ? null : scheme.getLong("defaultlevel");
        }
        return null;
    }

    public Long getDefaultSecurityLevel(Project project) {
        try {
            return this.getSchemeDefaultSecurityLevel(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue getIssueSecurityLevel(Long id) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().findByPrimaryKey("SchemeIssueSecurityLevels", EasyMap.build((Object)"id", (Object)id));
    }

    public void deleteSecurityLevel(Long levelId) {
        this.entityEngine.delete(Delete.from("SchemeIssueSecurities").whereEqual("security", levelId));
        this.entityEngine.delete(Delete.from(Entity.ISSUE_SECURITY_LEVEL).whereIdEquals(levelId));
    }

    public void clearUsersLevels() {
        this.projectSecurityLevels.clear();
    }

    public void clearProjectLevels(GenericValue project) {
        if (project != null) {
            this.projectSecurityLevels.remove(project.getLong("id"));
        }
    }
}

