/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComponentSearchContextVisibilityChecker
implements SearchContextVisibilityChecker {
    private final ProjectComponentManager componentManager;

    public ComponentSearchContextVisibilityChecker(ProjectComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public Set<String> FilterOutNonVisibleInContext(SearchContext searchContext, Collection<String> ids) {
        List projects = searchContext.getProjectIds();
        if (projects.size() != 1) {
            return Collections.emptySet();
        }
        HashSet<String> visibleIds = new HashSet<String>();
        for (String sid : ids) {
            Long lid = this.parseLong(sid);
            if (lid == null) continue;
            try {
                Long pid = this.componentManager.findProjectIdForComponent(lid);
                if (!projects.contains(pid)) continue;
                visibleIds.add(sid);
            }
            catch (EntityNotFoundException ignored) {}
        }
        return visibleIds;
    }

    private Long parseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

