/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.DescriptionIndexer;
import com.atlassian.jira.issue.index.indexers.impl.EnvironmentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SummaryIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.QuerySearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.QuerySearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class QuerySearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    public static final String ID = "query";
    public static final String QUERY_FIELDS_ID = "queryFields";
    public static final Set<String> QUERY_JQL_FIELD_NAMES;
    public static final Set<String> QUERY_URL_FIELD_PARAMS;
    public static final String QUERY_URL_PARAM = "query";
    private static final String NAME_KEY = "common.words.query";
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public QuerySearcher(VelocityRequestContextFactory velocityRequestContextFactory, VelocityManager velocityManager, ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver operandResolver) {
        List indexers = CollectionBuilder.newBuilder((Object[])new Class[]{DescriptionIndexer.class, SummaryIndexer.class, EnvironmentIndexer.class}).asList();
        this.searcherInformation = new GenericSearcherInformation("query", NAME_KEY, indexers, this.fieldReference, SearcherGroupType.TEXT);
        this.searchInputTransformer = new QuerySearchInputTransformer(applicationProperties, operandResolver);
        this.searchRenderer = new QuerySearchRenderer(velocityRequestContextFactory, NAME_KEY, applicationProperties, velocityManager, operandResolver, fieldVisibilityManager);
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }

    static {
        TreeSet queryJqlFieldName = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        queryJqlFieldName.addAll(SystemSearchConstants.forSummary().getJqlClauseNames().getJqlFieldNames());
        queryJqlFieldName.addAll(SystemSearchConstants.forDescription().getJqlClauseNames().getJqlFieldNames());
        queryJqlFieldName.addAll(SystemSearchConstants.forEnvironment().getJqlClauseNames().getJqlFieldNames());
        queryJqlFieldName.addAll(SystemSearchConstants.forComments().getJqlClauseNames().getJqlFieldNames());
        QUERY_JQL_FIELD_NAMES = Collections.unmodifiableSet(queryJqlFieldName);
        QUERY_URL_FIELD_PARAMS = CollectionBuilder.newBuilder((Object[])new String[]{SystemSearchConstants.forSummary().getUrlParameter(), SystemSearchConstants.forDescription().getUrlParameter(), SystemSearchConstants.forEnvironment().getUrlParameter(), SystemSearchConstants.forComments().getUrlParameter()}).asSet();
    }
}

