/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.util.profiling.UtilTimerStack;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;

public class PermissionsFilterGeneratorImpl
implements PermissionsFilterGenerator {
    private static final Logger log = Logger.getLogger(PermissionsFilterGeneratorImpl.class);
    private final PermissionQueryFactory permissionQueryFactory;

    public PermissionsFilterGeneratorImpl(PermissionQueryFactory permissionQueryFactory) {
        this.permissionQueryFactory = permissionQueryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query getQuery(User searcher) {
        try {
            UtilTimerStack.push((String)"Permission Query");
            Query query = this.getCache().getQuery(searcher);
            if (query == null) {
                query = this.permissionQueryFactory.getQuery(searcher, 10);
                this.getCache().storeQuery(query, searcher);
            }
            Query query2 = query;
            return query2;
        }
        finally {
            UtilTimerStack.pop((String)"Permission Query");
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new PermissionsFilterCache");
            }
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }
}

