/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.ofbiz.PagedDatabaseIterable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizSearchRequestStore
implements SearchRequestStore {
    static final SharedEntity.TypeDescriptor<SearchRequest> ENTITY_TYPE = SearchRequest.ENTITY_TYPE;
    private static final Logger log = Logger.getLogger(OfBizSearchRequestStore.class);
    private final JqlQueryParser jqlQueryParser;
    private final SearchService searchService;
    private final OfBizDelegator delegator;
    private final Resolver<GenericValue, SearchRequest> searchRequestResolver = new Resolver<GenericValue, SearchRequest>(){

        public SearchRequest get(GenericValue input) {
            return OfBizSearchRequestStore.this.convertGVToRequest(input);
        }
    };
    private final Resolver<GenericValue, IndexableSharedEntity<SearchRequest>> indexableSharedEntityResolver = new Resolver<GenericValue, IndexableSharedEntity<SearchRequest>>(){

        public IndexableSharedEntity<SearchRequest> get(GenericValue input) {
            return OfBizSearchRequestStore.this.convertGVToIndexableSharedEntity(input);
        }
    };

    public OfBizSearchRequestStore(OfBizDelegator delegator, JqlQueryParser jqlQueryParser, SearchService searchService) {
        this.jqlQueryParser = jqlQueryParser;
        this.searchService = searchService;
        Assertions.notNull((String)"delegator", (Object)delegator);
        this.delegator = delegator;
    }

    @Override
    @Deprecated
    public Collection<SearchRequest> getAllRequests() {
        return CollectionUtil.transform(this.delegator.findAll(Table.NAME).iterator(), this.searchRequestResolver);
    }

    @Override
    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        Resolver<SearchRequest, Long> keyResolver = descriptor.preserveOrder() ? new Resolver<SearchRequest, Long>(){

            public Long get(SearchRequest input) {
                return input.getId();
            }
        } : null;
        return new PagedDatabaseIterable<SearchRequest, Long>(descriptor.getIds(), (Resolver)keyResolver){

            @Override
            protected OfBizListIterator createListIterator(List<Long> ids) {
                return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, (EntityCondition)new EntityExpr("id", EntityOperator.IN, ids));
            }

            @Override
            protected Resolver<GenericValue, SearchRequest> getResolver() {
                return OfBizSearchRequestStore.this.searchRequestResolver;
            }
        };
    }

    @Override
    public EnclosedIterable<SearchRequest> getAll() {
        try {
            return new DatabaseIterable<SearchRequest>(new Long(this.delegator.getCount(Table.NAME)).intValue(), this.searchRequestResolver){

                @Override
                protected OfBizListIterator createListIterator() {
                    return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, null);
                }
            };
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnclosedIterable<IndexableSharedEntity<SearchRequest>> getAllIndexableSharedEntities() {
        try {
            return new DatabaseIterable<IndexableSharedEntity<SearchRequest>>(new Long(this.delegator.getCount(Table.NAME)).intValue(), this.indexableSharedEntityResolver){

                @Override
                protected OfBizListIterator createListIterator() {
                    return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, null);
                }
            };
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
    }

    int getSearchRequestCountForProject(Long projectId) {
        EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)"project", (Object)projectId), EntityOperator.AND);
        GenericValue countGV = EntityUtil.getOnly((List)this.delegator.findByCondition(Table.COUNT, (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.EMPTY_LIST));
        return countGV.getLong("count").intValue();
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(User author) {
        return CollectionUtil.transform(this.getSearchRequestGVsOwnedBy(author).iterator(), this.searchRequestResolver);
    }

    @Override
    public SearchRequest getRequestByAuthorAndName(User author, String name) {
        if (author == null) {
            return null;
        }
        List genericValues = this.delegator.findByAnd(Table.NAME, EasyMap.build((Object)"author", (Object)author.getName(), (Object)"name", (Object)name));
        return this.convertGVToRequest(EntityUtil.getOnly((List)genericValues));
    }

    @Override
    public SearchRequest getSearchRequest(Long id) {
        return this.convertGVToRequest(this.findByPrimaryKey(id));
    }

    @Override
    public SearchRequest create(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        GenericValue gv = this.delegator.createValue(Table.NAME, EasyMap.build((Object)"name", (Object)request.getName(), (Object)"project", null, (Object)"description", (Object)request.getDescription(), (Object)"author", (Object)request.getOwnerUserName(), (Object)"user", (Object)request.getOwnerUserName(), (Object)"request", (Object)this.searchService.getJqlString(request.getQuery()), (Object)"favCount", (Object)new Long(0L)));
        return this.convertGVToRequest(gv);
    }

    @Override
    public SearchRequest update(SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        GenericValue searchFilter = this.findByPrimaryKey(request.getId());
        searchFilter.setString("name", request.getName());
        searchFilter.setString("description", request.getDescription());
        searchFilter.setString("request", this.searchService.getJqlString(request.getQuery()));
        searchFilter.setString("author", request.getOwnerUserName());
        searchFilter.remove((Object)"favCount");
        this.delegator.store(searchFilter);
        return this.getSearchRequest(request.getId());
    }

    @Override
    public SearchRequest adjustFavouriteCount(Long searchRequestId, int incrementValue) {
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        GenericValue gv = this.findByPrimaryKey(searchRequestId);
        if (gv == null) {
            return null;
        }
        Long currentFavcount = gv.getLong("favCount");
        long newFavcount = currentFavcount == null ? 0L : currentFavcount;
        if ((newFavcount += (long)incrementValue) < 0L) {
            newFavcount = 0L;
        }
        gv.set("favCount", (Object)new Long(newFavcount));
        this.delegator.store(gv);
        return this.getSearchRequest(searchRequestId);
    }

    @Override
    public void delete(Long id) {
        GenericValue gv = this.findByPrimaryKey(id);
        if (gv == null) {
            throw new DataAccessException("SearchRequest does not exist.  Can not delete.");
        }
        this.delegator.removeValue(gv);
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(final Project project) {
        Assertions.notNull((String)"project", (Object)project);
        Long projectId = project.getId();
        return new DatabaseIterable<SearchRequest>(this.getSearchRequestCountForProject(projectId), this.searchRequestResolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, (EntityCondition)new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId()));
            }
        };
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        Resolver<GenericValue, SearchRequest> resolver = new Resolver<GenericValue, SearchRequest>(){

            public SearchRequest get(GenericValue sharedEntityGV) {
                GenericDelegator genericDelegator = sharedEntityGV.getDelegator();
                return OfBizSearchRequestStore.this.convertGVToRequest(genericDelegator.makeValue(Table.NAME, this.filter(sharedEntityGV.getAllFields())));
            }

            private final Map<String, ?> filter(Map<String, ?> fields) {
                HashMap result = new HashMap(fields);
                result.remove("param1");
                result.remove("param2");
                result.remove("entityId");
                result.remove("type");
                result.remove("entityType");
                return Collections.unmodifiableMap(result);
            }
        };
        final EntityExprList expr = new EntityExprList(EasyList.build((Object)new EntityExpr("type", EntityOperator.EQUALS, (Object)GroupShareType.TYPE.get()), (Object)new EntityExpr("param1", EntityOperator.EQUALS, (Object)group.getName())), EntityOperator.AND);
        return new DatabaseIterable<SearchRequest>(-1, (Resolver)resolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.SHARE, (EntityCondition)expr);
            }
        };
    }

    private GenericValue findByPrimaryKey(Long id) {
        return this.delegator.findByPrimaryKey(Table.NAME, EasyMap.build((Object)"id", (Object)id));
    }

    private List<GenericValue> getSearchRequestGVsOwnedBy(User author) {
        if (author == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        entityExpressions.add(new EntityExpr("author", EntityOperator.EQUALS, (Object)author.getName()));
        return this.delegator.findByOr(Table.NAME, entityExpressions, EasyList.build((Object)"name"));
    }

    private IndexableSharedEntity<SearchRequest> convertGVToIndexableSharedEntity(GenericValue requestGV) {
        if (requestGV == null) {
            return null;
        }
        String userName = requestGV.getString("author");
        String name = requestGV.getString("name");
        String description = requestGV.getString("description");
        Long id = requestGV.getLong("id");
        Long favCount = requestGV.getLong("favCount");
        if (favCount == null) {
            favCount = 0L;
        }
        return new IndexableSharedEntity<SearchRequest>(id, name, description, SearchRequest.ENTITY_TYPE, userName, favCount);
    }

    private SearchRequest convertGVToRequest(GenericValue requestGV) {
        if (requestGV == null) {
            return null;
        }
        Query query = this.getSearchQueryFromGv(requestGV);
        String userName = requestGV.getString("author");
        String name = requestGV.getString("name");
        String description = requestGV.getString("description");
        Long id = requestGV.getLong("id");
        Long favCount = requestGV.getLong("favCount");
        if (favCount == null) {
            favCount = 0L;
        }
        return new SearchRequest(query, userName, name, description, id, favCount.longValue());
    }

    Query getSearchQueryFromGv(GenericValue searchRequestGv) {
        String queryString = searchRequestGv.getString("request");
        String jql = queryString == null ? "" : queryString;
        try {
            return this.jqlQueryParser.parseQuery(jql);
        }
        catch (JqlParseException e) {
            log.error((Object)("A JQL query exception was thrown parsing, error loading search request with id '" + searchRequestGv.getLong("id") + "' and name '" + searchRequestGv.getString("name") + "' owned by '" + searchRequestGv.getString("author") + "' query '" + jql + "'."));
            throw new DataAccessException((Throwable)e);
        }
    }

    private static final class Column {
        private static final String AUTHOR = "author";
        private static final String NAME = "name";
        private static final String ID = "id";
        private static final String PROJECT = "project";
        private static final String DESCRIPTION = "description";
        private static final String USER = "user";
        private static final String REQUEST = "request";
        private static final String FAV_COUNT = "favCount";
        private static final String COUNT = "count";

        private Column() {
        }
    }

    static final class Table {
        static final String NAME = ENTITY_TYPE.getName();
        static final String COUNT = NAME + "Count";
        static final String SHARE = NAME + "ShareView";

        Table() {
        }
    }
}

