/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.pager;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="TODO Needs to be fixed")
public class NextPreviousPager
implements Serializable {
    private static final Logger log = Logger.getLogger(NextPreviousPager.class);
    static final int DEFAULT_CACHE_SIZE = 40;
    private static final FieldSelector FIELD_SELECTOR = new SetBasedFieldSelector(Collections.singleton("key"), Collections.emptySet());
    private List<Integer> docIds;
    private Map<Integer, Integer> docIdToPos;
    private List<String> issueKeys;
    private int currentKeyPos = -1;
    private int searchRequestHashCode = -1;
    private long readerVersion;
    private int offset;
    private int cacheSize = 40;

    public NextPreviousPager(NextPreviousPager that) {
        this.currentKeyPos = that.currentKeyPos;
        this.searchRequestHashCode = that.searchRequestHashCode;
        this.readerVersion = that.readerVersion;
        this.offset = that.offset;
        this.cacheSize = that.cacheSize;
        this.docIds = that.docIds == null ? that.docIds : new ArrayList<Integer>(that.docIds);
        this.docIdToPos = that.docIdToPos == null ? that.docIdToPos : new HashMap<Integer, Integer>(that.docIdToPos);
        this.issueKeys = that.issueKeys == null ? that.issueKeys : new ArrayList<String>(that.issueKeys);
    }

    public NextPreviousPager(ApplicationProperties applicationProperties) {
        String cacheSizeStr;
        if (applicationProperties != null && !StringUtils.isBlank((String)(cacheSizeStr = applicationProperties.getDefaultBackedString("jira.previous.next.cache.size")))) {
            try {
                this.cacheSize = Integer.parseInt(cacheSizeStr);
                if (this.cacheSize < 3) {
                    log.warn((Object)"Issue key cache size can not be less than 3, Setting it to default.");
                    this.cacheSize = 40;
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"Exception thrown while trying to convert jira-application.properties key 'jira.previous.next.cache.size'. Ignoring and setting to default: '40'", (Throwable)nfe);
            }
        }
    }

    public boolean isHasCurrentKey() {
        return this.getCurrentKey() != null;
    }

    public String getCurrentKey() {
        return this.getKeyForPosition(this.currentKeyPos);
    }

    public int getCurrentPosition() {
        return this.currentKeyPos + 1;
    }

    public int getCurrentSize() {
        return this.docIds == null ? 0 : this.docIds.size();
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    public String getNextKey() {
        return this.getCurrentKey() == null ? null : this.getKeyForPosition(this.currentKeyPos + 1);
    }

    public String getPreviousKey() {
        return this.getCurrentKey() == null ? null : this.getKeyForPosition(this.currentKeyPos - 1);
    }

    public synchronized void update(SearchRequest searchRequest, User user, String currentKey) throws IOException, SearchException {
        this.currentKeyPos = -1;
        if (searchRequest == null) {
            log.debug((Object)"NextPreviousPager being updated with null serachrequest");
            return;
        }
        if (currentKey == null) {
            log.debug((Object)"NextPreviousPager being updated with null currentKey");
            return;
        }
        Integer currentIssueDocId = this.getCurrentDocId(currentKey);
        if (currentIssueDocId == null) {
            log.debug((Object)("NextPreviousPager being updated with currentKey that does not exist in index - " + currentKey));
            return;
        }
        if (this.searchRequestHashCode != searchRequest.hashCode()) {
            log.debug((Object)"SearchRequest has changed from previous update, reloading doc ids");
            this.currentKeyPos = this.populateDocIdsAndGetCurrentKeyPosition(searchRequest, user, currentIssueDocId);
        } else {
            this.currentKeyPos = this.getCurrentKeyPositionFromKeyCache(currentKey);
            if (this.currentKeyPos != -1) {
                log.debug((Object)"NextPreviousPager conains all needed key in cache, no need to load keys");
                return;
            }
            if (this.readerVersion != this.getReader().getVersion()) {
                log.debug((Object)"Need to load issue keys, though reader has been swapped out so we need to repopulate doc ids");
                this.currentKeyPos = this.populateDocIdsAndGetCurrentKeyPosition(searchRequest, user, currentIssueDocId);
            } else {
                log.debug((Object)"Loading issue keys from same reader");
                this.currentKeyPos = this.getCurrentKeyPositionFromDocIds(currentIssueDocId);
            }
        }
        if (this.currentKeyPos != -1) {
            this.populateKeyCache();
        }
    }

    private Integer getCurrentDocId(String currentKey) throws IOException {
        TermDocs docs = this.getReader().termDocs(new Term("key", currentKey));
        return !docs.next() ? null : Integer.valueOf(docs.doc());
    }

    private void populateKeyCache() throws IOException {
        log.debug((Object)"Loading issue key cache");
        this.offset = this.currentKeyPos - this.cacheSize / 2;
        if (this.offset < 0) {
            this.offset = 0;
        }
        this.issueKeys = new ArrayList<String>(this.cacheSize);
        for (int i = this.offset; i < this.offset + this.cacheSize && i < this.docIds.size(); ++i) {
            this.issueKeys.add(this.getReader().document(this.docIds.get(i).intValue(), FIELD_SELECTOR).get("key"));
        }
    }

    private int populateDocIdsAndGetCurrentKeyPosition(@NotNull SearchRequest searchRequest, User user, int currentIssueDocId) throws SearchException, IOException {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        NextPreviousHitCollector collector = new NextPreviousHitCollector(currentIssueDocId);
        this.getSearchProvider().searchAndSort(searchRequest.getQuery(), user, (Collector)collector, PagerFilter.getUnlimitedFilter());
        this.docIds = collector.getDocIds();
        this.docIdToPos = collector.getDocIdToPosMap();
        this.searchRequestHashCode = searchRequest.hashCode();
        this.readerVersion = this.getReader().getVersion();
        return collector.getCurrentKeyPos();
    }

    private int getCurrentKeyPositionFromKeyCache(String currentKey) {
        if (this.issueKeys == null) {
            return -1;
        }
        int i = this.issueKeys.indexOf(currentKey);
        int newPos = this.offset + i;
        if (i == 0 && this.offset == 0) {
            return newPos;
        }
        if (i > 0 && i < this.issueKeys.size() - 1) {
            return newPos;
        }
        if (i == this.issueKeys.size() - 1 && this.offset + this.issueKeys.size() == this.docIds.size()) {
            return newPos;
        }
        return -1;
    }

    private int getCurrentKeyPositionFromDocIds(int currentIssueDocId) {
        return this.docIdToPos == null || !this.docIdToPos.containsKey(currentIssueDocId) ? -1 : this.docIdToPos.get(currentIssueDocId);
    }

    private String getKeyForPosition(int position) {
        if (position < 0 || position > this.docIds.size() - 1) {
            return null;
        }
        int relativePos = position - this.offset;
        if (relativePos < 0 || relativePos > this.issueKeys.size() - 1) {
            return null;
        }
        return this.issueKeys.get(relativePos);
    }

    IndexReader getReader() {
        return ComponentManager.getComponentInstanceOfType(IssueIndexManager.class).getIssueSearcher().getIndexReader();
    }

    SearchProvider getSearchProvider() {
        return ComponentManager.getComponentInstanceOfType(SearchProvider.class);
    }

    class NextPreviousHitCollector
    extends Collector {
        private final int currentIssueDocId;
        private final List<Integer> docIds = new ArrayList<Integer>();
        private final Map<Integer, Integer> docIdToPos = new HashMap<Integer, Integer>();
        int pos = 0;
        int currentKeyPos = -1;
        private int docBase;

        NextPreviousHitCollector(int currentIssueDocId) {
            this.currentIssueDocId = currentIssueDocId;
        }

        public void collect(int i) {
            int doc = this.docBase + i;
            this.docIds.add(doc);
            this.docIdToPos.put(doc, this.pos);
            if (this.currentIssueDocId == doc) {
                this.currentKeyPos = this.pos;
            }
            ++this.pos;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.docBase = docBase;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        List<Integer> getDocIds() {
            return this.docIds;
        }

        Map<Integer, Integer> getDocIdToPosMap() {
            return this.docIdToPos;
        }

        int getCurrentKeyPos() {
            return this.currentKeyPos;
        }
    }
}

