/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.jira.issue.link.RemoteJiraGlobalId;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class RemoteJiraGlobalIdFactory {
    private static final String ENCODING = "UTF-8";
    private static final String APP_ID_KEY = "appId";
    private static final String ISSUE_ID_KEY = "issueId";
    private final ApplicationLinkService applicationLinkService;

    public RemoteJiraGlobalIdFactory(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public static String encode(RemoteJiraGlobalId globalId) {
        return RemoteJiraGlobalIdFactory.encode(globalId.getApplicationLink().getId(), globalId.getRemoteIssueId());
    }

    public static String encode(ApplicationId applicationId, Long issueId) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(APP_ID_KEY, applicationId.get()));
        params.add(new BasicNameValuePair(ISSUE_ID_KEY, issueId.toString()));
        return URLEncodedUtils.format(params, (String)ENCODING);
    }

    public RemoteJiraGlobalId decode(String globalId) {
        Long issueId;
        ArrayList params = new ArrayList();
        Scanner scanner = new Scanner(globalId);
        try {
            URLEncodedUtils.parse(params, (Scanner)scanner, (String)ENCODING);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("globalId is invalid, expected format is: " + RemoteJiraGlobalIdFactory.getExpectedFormat() + ", found: " + globalId);
        }
        if (params.size() != 2 || !((NameValuePair)params.get(0)).getName().equals(APP_ID_KEY) || !((NameValuePair)params.get(1)).getName().equals(ISSUE_ID_KEY)) {
            throw new IllegalArgumentException("globalId is invalid, expected format is: " + RemoteJiraGlobalIdFactory.getExpectedFormat() + ", found: " + globalId);
        }
        String appId = ((NameValuePair)params.get(0)).getValue();
        ApplicationLink appLink = this.getApplicationLink(appId);
        if (appLink == null) {
            throw new IllegalArgumentException("No Application Link found for the given Application Id: " + appId);
        }
        String issueIdString = ((NameValuePair)params.get(1)).getValue();
        try {
            issueId = Long.parseLong(issueIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid Issue Id. Expecting intege, found: " + issueIdString);
        }
        return new RemoteJiraGlobalId(appLink, issueId);
    }

    private ApplicationLink getApplicationLink(String appId) {
        for (ApplicationLink appLink : this.applicationLinkService.getApplicationLinks(JiraApplicationType.class)) {
            if (!appLink.getId().get().equals(appId)) continue;
            return appLink;
        }
        return null;
    }

    private static String getExpectedFormat() {
        return "appId=<appId>&issueId=<issueId>";
    }
}

