/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class LabelsIndexer
extends BaseFieldIndexer {
    public static final String NO_VALUE_INDEX_VALUE = "<EMPTY>";

    public LabelsIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forLabels().getFieldId();
    }

    public String getDocumentFieldId() {
        return "labels_folded";
    }

    public void addIndex(Document doc, Issue issue) {
        Set labels = issue.getLabels();
        Field.Index index = this.unanalyzed(issue);
        if (labels == null || labels.isEmpty()) {
            if (!index.equals((Object)Field.Index.NO)) {
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), NO_VALUE_INDEX_VALUE, Field.Store.NO, index));
            }
        } else {
            for (Label label : labels) {
                String theLabel = label.getLabel();
                if (!StringUtils.isNotBlank((String)theLabel)) continue;
                doc.add((Fieldable)new Field("labels", theLabel, Field.Store.YES, index));
                if (index.equals((Object)Field.Index.NO)) continue;
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), theLabel.toLowerCase(), Field.Store.NO, index));
            }
        }
    }
}

