/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.AbstractDateRangeBuilder;
import org.apache.log4j.Logger;

public class StatusDateRangeBuilder
extends AbstractDateRangeBuilder {
    private static final Logger log = Logger.getLogger(StatusDateRangeBuilder.class);
    private static final String EMPTY_VALUE = "-1";

    public StatusDateRangeBuilder() {
        this("status");
    }

    public StatusDateRangeBuilder(String field) {
        super(field, EMPTY_VALUE);
    }

    @Override
    protected ChangeHistoryItem createInitialChangeItem(Issue issue) {
        String statusName = issue.getStatusObject() == null ? null : issue.getStatusObject().getName();
        String statusValue = issue.getStatusObject() == null ? EMPTY_VALUE : issue.getStatusObject().getId();
        return new ChangeHistoryItem.Builder().withId(-1L).inChangeGroup(-1L).forIssue(issue.getId().longValue(), issue.getKey()).inProject(issue.getProjectObject().getId().longValue()).field(this.getField()).on(issue.getCreated()).to(statusName, statusValue).byUser(issue.getReporter() == null ? "issue_no_reporter" : issue.getReporter().getName()).build();
    }
}

