/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultProjectIssueTypeScreenSchemeHelper
implements ProjectIssueTypeScreenSchemeHelper {
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ProjectService projectService;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectFactory projectFactory;

    public DefaultProjectIssueTypeScreenSchemeHelper(ProjectService projectService, JiraAuthenticationContext authenticationContext, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.projectService = projectService;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.projectFactory = projectFactory;
    }

    @Override
    public Multimap<FieldScreenScheme, Project> getProjectsForFieldScreenSchemes(Set<FieldScreenScheme> fieldScreenSchemes) {
        HashMap backingMap = Maps.newHashMap();
        SetMultimap fieldScreenSchemeToProjectMapping = Multimaps.newSetMultimap((Map)backingMap, (Supplier)new Supplier<Set<Project>>(){

            public Set<Project> get() {
                return Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
            }
        });
        List<Project> projects = this.getAllProjects();
        for (Project project : projects) {
            IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
            FieldScreenScheme defaultFieldScreenScheme = issueTypeScreenScheme.getEntity(null).getFieldScreenScheme();
            for (IssueType issueType : project.getIssueTypes()) {
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
                FieldScreenScheme fieldScreenScheme = issueTypeScreenSchemeEntity == null ? defaultFieldScreenScheme : issueTypeScreenSchemeEntity.getFieldScreenScheme();
                if (!fieldScreenSchemes.contains(fieldScreenScheme)) continue;
                fieldScreenSchemeToProjectMapping.put((Object)fieldScreenScheme, (Object)project);
            }
        }
        return fieldScreenSchemeToProjectMapping;
    }

    @Override
    public List<Project> getProjectsForFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        Multimap<FieldScreenScheme, Project> projectsForFieldScreenSchemes = this.getProjectsForFieldScreenSchemes(Collections.singleton(fieldScreenScheme));
        return Lists.newArrayList((Iterable)projectsForFieldScreenSchemes.get((Object)fieldScreenScheme));
    }

    @Override
    public List<Project> getProjectsForScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        TreeSet sharedProjects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        List projects = this.projectFactory.getProjects(issueTypeScreenScheme.getProjects());
        for (Project project : projects) {
            if (!this.hasEditPermission(this.authenticationContext.getLoggedInUser(), project)) continue;
            sharedProjects.add(project);
        }
        return Lists.newArrayList((Iterable)sharedProjects);
    }

    boolean hasEditPermission(User user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }

    private List<Project> getAllProjects() {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(this.authenticationContext.getLoggedInUser(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }
}

