/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class CachingFieldScreenStore
implements FieldScreenStore,
Startable {
    private final FieldScreenStore decoratedStore;
    private final EventPublisher eventPublisher;
    private volatile Map<Long, FieldScreen> fieldScreenMap;
    private volatile List<FieldScreen> fieldScreenList;

    public CachingFieldScreenStore(FieldScreenStore decoratedStore, EventPublisher eventPublisher) {
        this.decoratedStore = decoratedStore;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public void setFieldScreenManager(FieldScreenManager fieldScreenManager) {
        this.decoratedStore.setFieldScreenManager(fieldScreenManager);
    }

    @Override
    public FieldScreen getFieldScreen(Long id) {
        return this.fieldScreenMap.get(id);
    }

    @Override
    public List<FieldScreen> getFieldScreens() {
        return this.fieldScreenList;
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        this.decoratedStore.createFieldScreen(fieldScreen);
        this.refresh();
    }

    @Override
    public void removeFieldScreen(Long id) {
        this.decoratedStore.removeFieldScreen(id);
        this.refresh();
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        this.decoratedStore.updateFieldScreen(fieldScreen);
        this.refresh();
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.createFieldScreenTab(fieldScreenTab);
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.updateFieldScreenTab(fieldScreenTab);
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.decoratedStore.getFieldScreenTabs(fieldScreen);
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.decoratedStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public synchronized void refresh() {
        this.decoratedStore.refresh();
        this.populateCache();
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(GenericValue genericValue) {
        return this.decoratedStore.buildNewFieldScreenLayoutItem(genericValue);
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.decoratedStore.removeFieldScreenTabs(fieldScreen);
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        this.decoratedStore.removeFieldScreenTab(id);
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long tabId) {
        return this.decoratedStore.getFieldScreenTab(tabId);
    }

    private void populateCache() {
        List<FieldScreen> fs = this.decoratedStore.getFieldScreens();
        HashMap<Long, FieldScreen> screenMap = new HashMap<Long, FieldScreen>();
        for (FieldScreen fieldScreen : fs) {
            screenMap.put(fieldScreen.getId(), fieldScreen);
        }
        this.fieldScreenMap = Collections.unmodifiableMap(screenMap);
        this.fieldScreenList = Collections.unmodifiableList(fs);
    }
}

