/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorklogRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public WorklogRestFieldOperationsHandler(DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName());
    }

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (operations.size() > 1) {
            errors.addError("worklog", "only one 'add' operation supported");
            return errors;
        }
        for (FieldOperationHolder op : operations) {
            if (!op.getOperation().equals(StandardOperation.ADD.getName())) {
                errors.addError("worklog", "operation not supported: " + op.getOperation());
                continue;
            }
            JsonData data = op.getData();
            if (!data.isObject()) {
                errors.addError("worklog", "expected an object");
                continue;
            }
            Long mins = data.getObjectLongProperty("minutesSpent", (ErrorCollection)errors);
            Date start = data.getObjectDateProperty("started", (ErrorCollection)errors);
            if (errors.hasAnyErrors()) continue;
            Map actionParameters = inputParameters.getActionParameters();
            actionParameters.put("worklog_activate", new String[]{"true"});
            actionParameters.put("isCreateIssue", new String[]{"true"});
            actionParameters.put("worklog_adjustEstimate", new String[]{WorklogSystemField.WorklogValue.AdjustEstimate.AUTO.name()});
            if (mins != null) {
                actionParameters.put("worklog_timeLogged", new String[]{mins + "m"});
            }
            if (start == null) continue;
            DateTimeFormatter userDateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
            actionParameters.put("worklog_startDate", new String[]{userDateTimeFormatter.format(start)});
        }
        return errors;
    }
}

