/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.AbstractFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class SummaryRestFieldOperationsHandler
extends AbstractFieldOperationsHandler<String> {
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName());
    }

    @Override
    protected String getInitialCreateValue() {
        return "";
    }

    @Override
    protected String getInitialValue(Issue issue, ErrorCollection errors) {
        return issue.getSummary();
    }

    @Override
    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.setSummary(finalValue);
    }

    @Override
    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String fieldId, String currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (!operationValue.isString()) {
            errors.addError("summary", "Operation value must be a string", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return operationValue.asString();
    }
}

