/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.fields.rest.AbstractVersionsRestFieldOperationsHandler;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class FixForVersionsRestFieldOperationsHandler
extends AbstractVersionsRestFieldOperationsHandler {
    public FixForVersionsRestFieldOperationsHandler(VersionManager versionManager) {
        super(versionManager);
    }

    @Override
    protected String getFieldName() {
        return "fixVersions";
    }

    @Override
    protected List<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Iterable versions = Iterables.transform((Iterable)issue.getFixVersions(), (Function)new Function<Version, String>(){

            public String apply(Version from) {
                return from.getId().toString();
            }
        });
        return Lists.newArrayList((Iterable)versions);
    }

    @Override
    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        Long[] ids = this.toVersionIds(finalValue, errors);
        if (ids != null) {
            parameters.setFixVersionIds(ids);
        }
    }
}

