/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.AbstractFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComponentsRestFieldOperationsHandler
extends AbstractFieldOperationsHandler<Collection<String>> {
    private final ProjectComponentManager projectComponentManager;

    public ComponentsRestFieldOperationsHandler(ProjectComponentManager projectComponentManager) {
        this.projectComponentManager = projectComponentManager;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    @Override
    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        String componentName;
        ComponentJsonBean bean = (ComponentJsonBean)operationValue.convertValue("components", ComponentJsonBean.class, errors);
        if (bean == null) {
            return currentFieldValue;
        }
        String componentId = bean.getId();
        if (componentId == null && (componentName = bean.getName()) != null) {
            ProjectComponent component = this.projectComponentManager.findByComponentName(issueCtx.getProjectObject().getId(), componentName);
            if (component != null) {
                componentId = component.getId().toString();
            } else {
                errors.addError(fieldId, "Component name '" + componentName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (componentId == null) {
            errors.addError(fieldId, "Could not find valid 'id' or 'name' in component object.", ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        return Collections2.filter(currentFieldValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)componentId)));
    }

    @Override
    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        List componentNames;
        HashSet<String> uniqueComponentIds = new HashSet<String>();
        List componentIds = operationValue.asArrayOfObjectsWithId("components", errors);
        if (componentIds != null) {
            uniqueComponentIds.addAll(componentIds);
        }
        if ((componentNames = operationValue.asArrayOfObjectsWithProperty("name", "components", errors)) != null) {
            for (String componentName : componentNames) {
                ProjectComponent component = this.projectComponentManager.findByComponentName(issueCtx.getProjectObject().getId(), componentName);
                if (component != null) {
                    uniqueComponentIds.add(component.getId().toString());
                    continue;
                }
                errors.addError(fieldId, "Component name '" + componentName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        return uniqueComponentIds;
    }

    @Override
    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, String fieldId, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        String componentName;
        String componentId = operationValue.asObjectWithProperty("id", "components", errors);
        if (componentId == null && (componentName = operationValue.asObjectWithProperty("name", "components", errors)) != null) {
            ProjectComponent component = this.projectComponentManager.findByComponentName(issueCtx.getProjectObject().getId(), componentName);
            if (component != null) {
                componentId = component.getId().toString();
            } else {
                errors.addError(fieldId, "Component name '" + componentName + "' is not valid", ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        if (componentId == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>(currentFieldValue);
        if (!newList.contains(componentId)) {
            newList.add(componentId);
        }
        return newList;
    }

    @Override
    protected Collection<String> getInitialCreateValue() {
        return Collections.emptyList();
    }

    @Override
    protected Collection<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Iterable components = Iterables.transform((Iterable)issue.getComponentObjects(), (Function)new Function<ProjectComponent, String>(){

            public String apply(ProjectComponent from) {
                return from.getId().toString();
            }
        });
        return Lists.newArrayList((Iterable)components);
    }

    @Override
    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        Long[] ids = this.toLongIds(finalValue, "components", errors);
        if (ids != null) {
            parameters.setComponentIds(ids);
        }
    }
}

