/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.rest.AbstractFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.CommentOperationHolder;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CommentFieldOperationsHandler
extends AbstractFieldOperationsHandler<CommentOperationHolder> {
    private final CommentManager commentManager;

    public CommentFieldOperationsHandler(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.EDIT.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    @Override
    protected CommentOperationHolder getInitialValue(Issue issue, ErrorCollection errors) {
        return null;
    }

    @Override
    protected CommentOperationHolder getInitialCreateValue() {
        return null;
    }

    @Override
    protected CommentOperationHolder handleRemoveOperation(IssueContext issueCtx, Issue issue, String fieldId, CommentOperationHolder currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        return this.createOperationHolder(operationValue, errors, StandardOperation.REMOVE);
    }

    @Override
    protected CommentOperationHolder handleAddOperation(IssueContext issueCtx, Issue issue, String fieldId, CommentOperationHolder currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        return this.createOperationHolder(operationValue, errors, StandardOperation.ADD);
    }

    @Override
    protected CommentOperationHolder applyOperation(IssueContext issueCtx, Issue issue, String fieldId, StandardOperation operation, CommentOperationHolder currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operation.equals((Object)StandardOperation.EDIT)) {
            return this.createOperationHolder(operationValue, errors, StandardOperation.EDIT);
        }
        return super.applyOperation(issueCtx, issue, fieldId, operation, currentFieldValue, operationValue, errors);
    }

    private CommentOperationHolder createOperationHolder(JsonData operationValue, ErrorCollection errors, StandardOperation operation) {
        String body = operationValue.getObjectStringProperty("body", "comment", errors);
        String id = operationValue.getObjectStringProperty("id", "comment", errors);
        String roleLevel = operationValue.getObjectStringProperty("roleLevel", "comment", errors);
        String groupLevel = operationValue.getObjectStringProperty("groupLevel", "comment", errors);
        CommentOperationHolder commentHolder = new CommentOperationHolder();
        commentHolder.id = id;
        commentHolder.body = body;
        commentHolder.group = groupLevel;
        commentHolder.role = roleLevel;
        commentHolder.operation = operation;
        return commentHolder;
    }

    @Override
    protected void finaliseOperation(CommentOperationHolder finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        String securityLevel;
        switch (finalValue.operation) {
            case ADD: {
                this.finaliseAddOperation(finalValue, parameters, errors);
                break;
            }
            case EDIT: {
                this.finaliseEditOperation(finalValue, parameters, errors);
                break;
            }
            case REMOVE: {
                parameters.getActionParameters().put("comment.remove.param", new String[]{"true"});
            }
        }
        if (StringUtils.isNotBlank((String)finalValue.group) && StringUtils.isNotBlank((String)finalValue.role)) {
            errors.addError("comment", "A comment can only have a role level OR a group level security protection.");
            return;
        }
        if (finalValue.role != null && StringUtils.isBlank((String)finalValue.role) && StringUtils.isBlank((String)finalValue.group)) {
            securityLevel = CommentVisibility.getRoleLevelWithPrefix(finalValue.role);
        } else {
            Long roleLevelId = null;
            if (StringUtils.isNotEmpty((String)finalValue.role)) {
                try {
                    roleLevelId = Long.valueOf(finalValue.role);
                }
                catch (NumberFormatException ex) {
                    errors.addError("comment", "Invalid role level id specified.");
                }
            }
            securityLevel = CommentVisibility.getCommentLevelFromLevels(finalValue.group, roleLevelId);
        }
        ArrayList<String> commentSecurity = new ArrayList<String>();
        commentSecurity.add(securityLevel);
        parameters.getActionParameters().put("commentLevel", commentSecurity.toArray(new String[commentSecurity.size()]));
    }

    private void finaliseEditOperation(CommentOperationHolder finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        ArrayList<String> commentParams;
        block6: {
            parameters.getActionParameters().put("comment.edit.param", new String[]{"true"});
            if (StringUtils.isNotEmpty((String)finalValue.id)) {
                parameters.getActionParameters().put("comment:id", new String[]{finalValue.id});
            }
            commentParams = new ArrayList<String>();
            if (finalValue.body == null) {
                try {
                    Comment comment = this.commentManager.getCommentById(Long.valueOf(finalValue.id));
                    if (comment != null) {
                        commentParams.add(comment.getBody());
                        break block6;
                    }
                    commentParams.add("DUMMY BODY");
                }
                catch (NumberFormatException ex) {
                    commentParams.add("DUMMY BODY");
                }
            } else {
                commentParams.add(finalValue.body);
            }
        }
        parameters.getActionParameters().put("comment", commentParams.toArray(new String[commentParams.size()]));
    }

    private void finaliseAddOperation(CommentOperationHolder finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.getActionParameters().put("comment.create.param", new String[]{"true"});
        ArrayList<String> commentParams = new ArrayList<String>();
        commentParams.add(finalValue.body);
        parameters.getActionParameters().put("comment", commentParams.toArray(new String[commentParams.size()]));
    }
}

