/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.renderer.links.Link;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class JiraIssueLink
extends Link {
    private static final Logger log = Logger.getLogger(JiraIssueLink.class);

    public JiraIssueLink(String issueKey) throws ParseException {
        this(issueKey, null);
    }

    public JiraIssueLink(String issueKey, String linkTitle) throws ParseException {
        super(issueKey);
        this.setupIssueLink(issueKey, linkTitle);
    }

    private void setupIssueLink(String key, String linkTitle) throws ParseException {
        MutableIssue issue;
        try {
            issue = ComponentAccessor.getIssueManager().getIssueObject(key);
            if (issue != null) {
                if (!this.canCurrentUserSeeIssue((Issue)issue)) {
                    throw new ParseException("Current user cannot see issue with key " + key, 0);
                }
                this.title = issue.getSummary();
                this.url = this.getBaseUrl() + "/browse/" + issue.getKey();
                this.linkBody = issue.getResolutionObject() != null ? "-" + (linkTitle == null ? key : linkTitle) + "-" : (linkTitle == null ? key : linkTitle);
            }
        }
        catch (Exception e) {
            log.info((Object)("Unable to resolve an issue with key: " + key));
            throw new IllegalArgumentException("No issue found with key " + key);
        }
        if (issue == null) {
            throw new ParseException("Unable to resolve the JIRA issue for key: " + key, 0);
        }
    }

    boolean canCurrentUserSeeIssue(Issue issue) {
        User user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        return ComponentAccessor.getPermissionManager().hasPermission(10, issue, user);
    }

    private String getBaseUrl() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(applicationProperties).getJiraVelocityRequestContext();
        return velocityRequestContext.getBaseUrl();
    }
}

