/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractFieldLayoutManager
implements FieldLayoutManager,
Startable {
    private static final Logger log = Logger.getLogger(AbstractFieldLayoutManager.class);
    public static final String SCHEME = "FieldLayoutScheme";
    public static final String SCHEME_ASSOCIATION = "ProjectFieldLayoutScheme";
    private final FieldManager fieldManager;
    private List<FieldLayoutItem> defaultFieldLayoutItems;
    private final ConcurrentMap<CacheObject<Long>, FieldLayout> fieldLayoutCache = new MapMaker().makeComputingMap((Function)new Function<CacheObject<Long>, FieldLayout>(){

        public FieldLayout apply(CacheObject<Long> from) {
            return AbstractFieldLayoutManager.this.loadFieldLayout(from.getValue());
        }
    });
    protected OfBizDelegator ofBizDelegator;

    public AbstractFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, I18nHelper.BeanFactory i18n) {
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.ofBizDelegator = ofBizDelegator;
    }

    public abstract FieldLayout getFieldLayout(Long var1);

    public abstract FieldLayout getFieldLayout(GenericValue var1);

    public abstract FieldLayout getFieldLayout(Project var1, String var2);

    public abstract FieldLayout getFieldLayout(GenericValue var1, String var2);

    public abstract List<FieldLayoutScheme> getFieldLayoutSchemes();

    public abstract void updateFieldLayoutScheme(FieldLayoutScheme var1);

    public abstract void deleteFieldLayoutScheme(FieldLayoutScheme var1);

    public abstract void restoreSchemeFieldLayout(GenericValue var1);

    public abstract Collection<GenericValue> getProjects(FieldConfigurationScheme var1);

    public abstract Collection<GenericValue> getProjects(FieldLayoutScheme var1);

    public abstract FieldLayoutScheme createFieldLayoutScheme(FieldLayoutScheme var1);

    public abstract FieldConfigurationScheme getFieldConfigurationScheme(Long var1);

    public abstract FieldConfigurationScheme getFieldConfigurationScheme(Project var1);

    public abstract FieldConfigurationScheme getFieldConfigurationScheme(GenericValue var1);

    public abstract Set<FieldLayout> getUniqueFieldLayouts(Project var1);

    public abstract FieldLayoutScheme getMutableFieldLayoutScheme(Long var1);

    public abstract boolean fieldConfigurationSchemeExists(String var1);

    public abstract List<EditableFieldLayout> getEditableFieldLayouts();

    public abstract void addSchemeAssociation(GenericValue var1, Long var2);

    public abstract void removeSchemeAssociation(GenericValue var1, Long var2);

    public abstract EditableFieldLayout getEditableFieldLayout(Long var1);

    public abstract void deleteFieldLayout(FieldLayout var1);

    public abstract Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeEntities(FieldLayoutScheme var1);

    public abstract void createFieldLayoutSchemeEntity(FieldLayoutSchemeEntity var1);

    public abstract void updateFieldLayoutSchemeEntity(FieldLayoutSchemeEntity var1);

    public abstract void removeFieldLayoutSchemeEntity(FieldLayoutSchemeEntity var1);

    public abstract void removeFieldLayoutScheme(FieldLayoutScheme var1);

    public abstract Collection<FieldConfigurationScheme> getFieldConfigurationSchemes(FieldLayout var1);

    public abstract Collection<GenericValue> getRelatedProjects(FieldLayout var1);

    public abstract boolean isFieldLayoutSchemesVisiblyEquivalent(Long var1, Long var2);

    public abstract boolean isFieldLayoutsVisiblyEquivalent(Long var1, Long var2);

    public void start() throws Exception {
        this.defaultFieldLayoutItems = this.getDefaultFieldLayoutItems();
    }

    protected List<FieldLayoutItem> getDefaultFieldLayoutItems() {
        return CollectionBuilder.newBuilder((Object[])new FieldLayoutItem[]{this.createFieldLayoutItemImpl("summary", true), this.createFieldLayoutItemImpl("issuetype", true), this.createFieldLayoutItemImpl("security", false), this.createFieldLayoutItemImpl("priority", false), this.createFieldLayoutItemImpl("duedate", false), this.createFieldLayoutItemImpl("components", false), this.createFieldLayoutItemImpl("versions", false), this.createFieldLayoutItemImpl("fixVersions", false), this.createFieldLayoutItemImpl("assignee", false), this.createFieldLayoutItemImpl("reporter", true), this.createFieldLayoutItemImpl("environment", false), this.createFieldLayoutItemImpl("description", false), this.createFieldLayoutItemImpl("timetracking", false), this.createFieldLayoutItemImpl("resolution", false), this.createFieldLayoutItemImpl("attachment", false), this.createFieldLayoutItemImpl("comment", false), this.createFieldLayoutItemImpl("labels", false), this.createFieldLayoutItemImpl("worklog", false), this.createFieldLayoutItemImpl("issuelinks", false)}).asList();
    }

    private FieldLayoutItem createFieldLayoutItemImpl(String fieldId, boolean required) {
        return new FieldLayoutItemImpl.Builder().setOrderableField(this.fieldManager.getOrderableField(fieldId)).setFieldDescription(this.getDefaultDescription(fieldId)).setHidden(false).setRequired(required).setFieldManager(this.fieldManager).build();
    }

    public FieldLayout getFieldLayout() {
        return this.getRelevantFieldLayout(null);
    }

    public FieldLayout getFieldLayout(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return this.getFieldLayout(issue.getProject(), issue.getIssueTypeObject().getId());
    }

    public EditableDefaultFieldLayout getEditableDefaultFieldLayout() {
        FieldLayout relevantFieldLayout = this.getRelevantFieldLayout(null);
        return new EditableDefaultFieldLayoutImpl(relevantFieldLayout.getGenericValue(), relevantFieldLayout.getFieldLayoutItems());
    }

    public void storeEditableDefaultFieldLayout(EditableDefaultFieldLayout editableDefaultFieldLayout) {
        this.storeEditableFieldLayout((EditableFieldLayout)editableDefaultFieldLayout);
        this.refreshCaches(editableDefaultFieldLayout.getId());
        this.refreshCaches(null);
    }

    public synchronized void storeEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        try {
            GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
            GenericValue fieldLayoutGV = editableFieldLayout.getGenericValue();
            if (editableFieldLayout.getGenericValue() == null) {
                fieldLayoutGV = EntityUtils.createValue("FieldLayout", EasyMap.build((Object)"name", (Object)editableFieldLayout.getName(), (Object)"description", (Object)editableFieldLayout.getDescription(), (Object)"type", (Object)editableFieldLayout.getType()));
            } else {
                fieldLayoutGV.store();
            }
            List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
            genericDelegator.removeAll(fieldLayoutItemGVs);
            List fieldLayoutItems = editableFieldLayout.getFieldLayoutItems();
            for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
                EntityUtils.createValue("FieldLayoutItem", EasyMap.build((Object)"fieldlayout", (Object)fieldLayoutGV.getLong("id"), (Object)"description", (Object)fieldLayoutItem.getFieldDescription(), (Object)"fieldidentifier", (Object)fieldLayoutItem.getOrderableField().getId(), (Object)"ishidden", (Object)Boolean.toString(fieldLayoutItem.isHidden()), (Object)"isrequired", (Object)Boolean.toString(fieldLayoutItem.isRequired()), (Object)"renderertype", (Object)fieldLayoutItem.getRendererType()));
            }
            this.refreshCaches(fieldLayoutGV.getLong("id"));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load the default FieldLayout", (Throwable)e);
        }
    }

    protected void refreshCaches(Long id) {
        this.fieldLayoutCache.remove(new CacheObject<Long>(id));
        this.fieldManager.getColumnLayoutManager().refresh();
    }

    public boolean hasDefaultFieldLayout() {
        try {
            GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
            return fieldLayoutGV == null;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void restoreDefaultFieldLayout() {
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        try {
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
            if (fieldLayoutGV != null) {
                fieldLayoutGV.removeRelated("ChildFieldLayoutItem");
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    protected synchronized void restoreFieldLayout(Long id) {
        try {
            GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)genericDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"id", (Object)id)));
            if (fieldLayoutGV != null) {
                List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
                genericDelegator.removeAll(fieldLayoutItemGVs);
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    public void refresh() {
        this.fieldLayoutCache.clear();
    }

    protected FieldLayout getRelevantFieldLayout(Long id) {
        return (FieldLayout)this.fieldLayoutCache.get(new CacheObject<Long>(id));
    }

    private FieldLayout loadFieldLayout(Long id) {
        try {
            ArrayList<Object> fieldLayoutItems;
            Set unavailableFields = this.fieldManager.getUnavailableFields();
            GenericValue fieldLayoutGV = null;
            if (id != null) {
                fieldLayoutGV = this.ofBizDelegator.findByPrimaryKey("FieldLayout", EasyMap.build((Object)"id", (Object)id));
            }
            if (fieldLayoutGV == null) {
                fieldLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
            }
            FieldLayoutImpl resultingLayout = new FieldLayoutImpl(fieldLayoutGV, null);
            if (fieldLayoutGV == null) {
                fieldLayoutItems = new ArrayList<FieldLayoutItem>(this.defaultFieldLayoutItems);
                for (int i = 0; i < fieldLayoutItems.size(); ++i) {
                    fieldLayoutItems.set(i, new FieldLayoutItemImpl.Builder((FieldLayoutItem)fieldLayoutItems.get(i)).setFieldLayout(resultingLayout).build());
                }
                List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects();
                for (CustomField customField : customFieldObjects) {
                    FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField((OrderableField)customField).setFieldDescription(null).setFieldLayout(resultingLayout);
                    fieldLayoutItems.add(builder.build());
                }
            } else {
                fieldLayoutItems = new ArrayList();
                List related = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
                for (GenericValue fieldLayoutItemGV : related) {
                    String fieldId = fieldLayoutItemGV.getString("fieldidentifier");
                    if (this.fieldManager.isOrderableField(fieldId)) {
                        FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField(this.fieldManager.getOrderableField(fieldId)).setFieldDescription(fieldLayoutItemGV.getString("description")).setHidden(Boolean.valueOf(fieldLayoutItemGV.getString("ishidden"))).setRequired(Boolean.valueOf(fieldLayoutItemGV.getString("isrequired"))).setRendererType(fieldLayoutItemGV.getString("renderertype")).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager);
                        fieldLayoutItems.add(builder.build());
                        continue;
                    }
                    log.info((Object)("Field layout contains non-orderable field with id '" + fieldId + "'."));
                }
                Set orderableFields = this.fieldManager.getOrderableFields();
                for (OrderableField orderableField : orderableFields) {
                    boolean found = false;
                    for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
                        if (!orderableField.equals(fieldLayoutItem.getOrderableField())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField(orderableField).setFieldDescription(this.getDefaultDescription(orderableField.getId())).setHidden(false).setRequired(this.fieldManager.isMandatoryField((Field)orderableField)).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager);
                    fieldLayoutItems.add(builder.build());
                }
            }
            Iterator iterator = fieldLayoutItems.iterator();
            while (iterator.hasNext()) {
                FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)iterator.next();
                if (!unavailableFields.contains(fieldLayoutItem.getOrderableField())) continue;
                iterator.remove();
            }
            resultingLayout.setFieldLayoutItems(new ArrayList<Object>(fieldLayoutItems));
            return resultingLayout;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new DataAccessException("Could not retrieve Field Layout.", (Throwable)e);
        }
    }

    protected String getDefaultDescription(String fieldId) {
        I18nHelper i18n = this.getI18nHelper();
        if ("environment".equals(fieldId)) {
            return i18n.getText("environment.field.description");
        }
        if ("timetracking".equals(fieldId)) {
            return i18n.getText("timetracking.field.description", "*w *d *h *m", "4d, 5h 30m, 60m", "3w");
        }
        if ("worklog".equals(fieldId)) {
            return i18n.getText("worklog.field.description");
        }
        return null;
    }

    protected I18nHelper getI18nHelper() {
        return new I18nBean(ComponentAccessor.getApplicationProperties().getDefaultLocale());
    }
}

