/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.util.map.NotNullHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigSchemePersisterImpl
implements FieldConfigSchemePersister {
    private static final Logger log = Logger.getLogger(FieldConfigSchemePersisterImpl.class);
    public static final String ENTITY_TABLE_NAME = "FieldConfigScheme";
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_DESCRIPTION = "description";
    public static final String ENTITY_FIELD = "fieldid";
    public static final String ENTITY_RELATED_TABLE_NAME = "FieldConfigSchemeIssueType";
    public static final String ENTITY_ISSUE_TYPE = "issuetype";
    public static final String ENTITY_SCHEME_ID = "fieldconfigscheme";
    public static final String ENTITY_CONFIG_ID = "fieldconfiguration";
    public static final String FK_RELATED_CONFIGS = "RelatedFieldConfigSchemeIssueType";
    private final OfBizDelegator delegator;
    private final ConstantsManager constantsManager;
    private final FieldConfigPersister fieldConfigPersister;
    private final FieldConfigContextPersister contextPersister;

    public FieldConfigSchemePersisterImpl(OfBizDelegator delegator, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister contextPersister) {
        this.delegator = delegator;
        this.constantsManager = constantsManager;
        this.fieldConfigPersister = fieldConfigPersister;
        this.contextPersister = contextPersister;
    }

    @Override
    public FieldConfigScheme create(FieldConfigScheme configScheme, ConfigurableField field) {
        Map<String, Object> fields = this.transformToFieldsMap(configScheme);
        fields.put(ENTITY_FIELD, field.getId());
        try {
            GenericValue createdGV = EntityUtils.createValue(ENTITY_TABLE_NAME, fields);
            Long createdId = createdGV.getLong(ENTITY_ID);
            this.storeConfigAssociations(configScheme.getConfigs(), createdId);
            return this.transformToDomainObject(createdGV, field);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to create FieldConfigScheme with values " + fields, (Throwable)e);
        }
    }

    @Override
    public FieldConfigScheme createWithDefaultValues(ConfigurableField field, Map<String, FieldConfig> configs) {
        FieldConfigScheme.Builder scheme = this.createBuilder();
        scheme.setName(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.customfields.default.config.scheme", field.getName()));
        scheme.setDescription(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.customfields.default.config.description"));
        scheme.setConfigs(configs);
        return this.create(scheme.toFieldConfigScheme(), field);
    }

    @Override
    public Collection<FieldConfigScheme> getInvalidFieldConfigSchemeAfterIssueTypeRemoval(IssueType issueType) {
        Null.not("issueType", issueType);
        HashSet<FieldConfigScheme> ret = new HashSet<FieldConfigScheme>();
        List gvs = this.delegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_ISSUE_TYPE, (Object)issueType.getId()));
        for (GenericValue fieldConfigSchemeIssueTypeGV : gvs) {
            Long fieldConfigSchemeId = fieldConfigSchemeIssueTypeGV.getLong(ENTITY_SCHEME_ID);
            List specificSchemes = this.delegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_SCHEME_ID, (Object)fieldConfigSchemeId));
            if (specificSchemes.size() != 1) continue;
            ret.add(this.getFieldConfigScheme(fieldConfigSchemeId));
        }
        return ret;
    }

    @Override
    public void removeByIssueType(IssueType issueType) {
        Null.not("issueType", issueType);
        this.delegator.removeByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_ISSUE_TYPE, (Object)issueType.getId()));
    }

    @Override
    public void init() {
    }

    @Override
    public FieldConfigScheme update(FieldConfigScheme configScheme) {
        try {
            GenericValue gv = this.findById(configScheme.getId());
            Map<String, Object> fields = this.transformToFieldsMap(configScheme);
            gv.setNonPKFields(fields);
            gv.store();
            gv.removeRelated(FK_RELATED_CONFIGS);
            this.storeConfigAssociations(configScheme.getConfigs(), configScheme.getId());
            return this.getFieldConfigScheme(configScheme.getId());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to store FieldConfigScheme: " + configScheme, (Throwable)e);
        }
    }

    @Override
    public void remove(Long fieldConfigSchemeId) {
        try {
            GenericValue gv = this.findById(fieldConfigSchemeId);
            gv.removeRelated(FK_RELATED_CONFIGS);
            gv.remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to remove FieldConfigScheme with id '" + fieldConfigSchemeId + "'", (Throwable)e);
        }
    }

    @Override
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        GenericValue gv = this.findById(configSchemeId);
        return this.transformToDomainObject(gv, null);
    }

    @Override
    public List<FieldConfigScheme> getConfigSchemesForCustomField(final ConfigurableField field) {
        List configs = this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_FIELD, (Object)field.getId()));
        return CollectionUtil.transform((Iterable)configs, (Function)new Function<GenericValue, FieldConfigScheme>(){

            public FieldConfigScheme get(GenericValue input) {
                return FieldConfigSchemePersisterImpl.this.transformToDomainObject(input, field);
            }
        });
    }

    @Override
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        Long fieldConfigId = fieldConfig.getId();
        List configs = this.delegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_CONFIG_ID, (Object)fieldConfigId));
        if (configs.isEmpty()) {
            throw new DataAccessException(String.format("Could not find any field config schemes for field config '%d'", fieldConfigId));
        }
        if (configs.size() > 1) {
            log.warn((Object)String.format("Found more than one field config scheme for field config '%d'; returning first one", fieldConfigId));
        }
        Long fieldConfigSchemeId = ((GenericValue)configs.get(0)).getLong(ENTITY_SCHEME_ID);
        return this.getFieldConfigScheme(fieldConfigSchemeId);
    }

    @Override
    public List<Long> getConfigSchemeIdsForCustomFieldId(String customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        List configs = this.delegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_FIELD, (Object)customFieldId));
        return CollectionUtil.transform((Iterable)configs, (Function)new Function<GenericValue, Long>(){

            public Long get(GenericValue input) {
                return input.getLong(FieldConfigSchemePersisterImpl.ENTITY_ID);
            }
        });
    }

    private Map<String, Object> transformToFieldsMap(FieldConfigScheme configScheme) {
        NotNullHashMap<String, Object> fields = new NotNullHashMap<String, Object>();
        fields.put(ENTITY_ID, configScheme.getId());
        fields.put(ENTITY_NAME, configScheme.getName());
        fields.put(ENTITY_DESCRIPTION, configScheme.getDescription());
        return fields;
    }

    FieldConfigScheme transformToDomainObject(GenericValue createdGV, ConfigurableField field) {
        try {
            FieldConfigScheme.Builder configScheme = this.createBuilder();
            configScheme.setId(createdGV.getLong(ENTITY_ID));
            configScheme.setName(createdGV.getString(ENTITY_NAME));
            configScheme.setDescription(createdGV.getString(ENTITY_DESCRIPTION));
            configScheme.setFieldId(createdGV.getString(ENTITY_FIELD));
            List related = createdGV.getRelated(FK_RELATED_CONFIGS);
            if (related != null && !related.isEmpty()) {
                HashMap<String, FieldConfig> configs = new HashMap<String, FieldConfig>(related.size());
                for (GenericValue gv : related) {
                    IssueType issueType = this.constantsManager.getIssueTypeObject(gv.getString(ENTITY_ISSUE_TYPE));
                    Long configId = gv.getLong(ENTITY_CONFIG_ID);
                    FieldConfig config = field != null ? this.fieldConfigPersister.getFieldConfig(configId, field) : this.fieldConfigPersister.getFieldConfig(configId);
                    String key = issueType == null ? null : issueType.getId();
                    configs.put(key, config);
                }
                configScheme.setConfigs(configs);
            }
            return configScheme.toFieldConfigScheme();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to retrieve custom field config " + createdGV, (Throwable)e);
        }
    }

    private GenericValue findById(Long configId) {
        return this.delegator.findByPrimaryKey(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_ID, (Object)configId));
    }

    private void storeConfigAssociations(Map<String, FieldConfig> configs, Long createdId) throws GenericEntityException {
        if (configs != null) {
            Set<Map.Entry<String, FieldConfig>> entries = configs.entrySet();
            for (Map.Entry<String, FieldConfig> entry : entries) {
                String issueType = entry.getKey();
                FieldConfig config = entry.getValue();
                Map relatedFields = MapBuilder.newBuilder((Object)ENTITY_ISSUE_TYPE, (Object)issueType).add((Object)ENTITY_SCHEME_ID, (Object)createdId).add((Object)ENTITY_CONFIG_ID, (Object)config.getId()).toMap();
                EntityUtils.createValue(ENTITY_RELATED_TABLE_NAME, relatedFields);
            }
        }
    }

    private FieldConfigScheme.Builder createBuilder() {
        FieldConfigScheme.Builder configScheme = new FieldConfigScheme.Builder();
        configScheme.setFieldConfigContextPersister(this.contextPersister);
        return configScheme;
    }
}

