/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigImpl;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.map.NotNullHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.CompositeCollection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigPersisterImpl
implements FieldConfigPersister {
    private static final String ENTITY_TABLE_NAME = "FieldConfiguration";
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_DESCRIPTION = "description";
    public static final String ENTITY_FIELD = "fieldid";
    private final OfBizDelegator delegator;

    public FieldConfigPersisterImpl(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    public FieldConfig create(FieldConfig config, List configurationItemTypes) {
        Map fields = this.transformToFieldsMap(config);
        try {
            GenericValue createdGV = EntityUtils.createValue(ENTITY_TABLE_NAME, fields);
            return this.transformToDomainObject(createdGV, configurationItemTypes);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to create FieldConfiguration with values " + fields, (Throwable)e);
        }
    }

    public FieldConfig createWithDefaultValues(ConfigurableField field) {
        String name = "Default Configuration for " + field.getName();
        String description = "Default configuration generated by JIRA";
        FieldConfigImpl config = new FieldConfigImpl(null, name, "Default configuration generated by JIRA", Collections.EMPTY_LIST, field.getId());
        return this.create(config, field.getConfigurationItemTypes());
    }

    public FieldConfig update(FieldConfig config) {
        try {
            GenericValue gv = this.findById(config.getId());
            Map fields = this.transformToFieldsMap(config);
            gv.setNonPKFields(fields);
            gv.store();
            CustomField customField = config.getCustomField();
            return this.transformToDomainObject(gv, customField.getConfigurationItemTypes());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to store FieldConfig: " + config, (Throwable)e);
        }
    }

    public void remove(FieldConfig config) {
        this.removeImpl(config.getId());
    }

    private void removeImpl(Long id) {
        try {
            this.findById(id).remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to remove FieldConfig id: " + id, (Throwable)e);
        }
    }

    public Collection getConfigsExclusiveToConfigScheme(final Long fieldConfigSchemeId) {
        class ExclusiveConfigFinder {
            private static final String MAPPING_TABLE = "FieldConfigSchemeIssueType";
            private static final String SCHEME_COLUMN = "fieldconfigscheme";
            private static final String CONFIG_COLUMN = "fieldconfiguration";
            private final List delete = new ArrayList();
            private final List ignore = new ArrayList();
            private final Collection alreadyProcessed = new CompositeCollection(new Collection[]{this.delete, this.ignore});

            ExclusiveConfigFinder() {
            }

            Collection process() {
                List fieldConfigSchemeIssueTypeMappings = FieldConfigPersisterImpl.this.delegator.findByAnd(MAPPING_TABLE, EasyMap.build((Object)SCHEME_COLUMN, (Object)fieldConfigSchemeId));
                for (GenericValue fieldConfigSchemeIssueTypeGV : fieldConfigSchemeIssueTypeMappings) {
                    this.add(fieldConfigSchemeIssueTypeGV.getLong(CONFIG_COLUMN));
                }
                CollectionUtils.transform((Collection)this.delete, (Transformer)new Transformer(){

                    public Object transform(Object input) {
                        return FieldConfigPersisterImpl.this.getFieldConfig((Long)input);
                    }
                });
                return Collections.unmodifiableCollection(this.delete);
            }

            private void add(Long configId) {
                if (this.alreadyProcessed.contains(configId)) {
                    return;
                }
                if (this.fieldConfigIsExclusiveToScheme(configId)) {
                    this.delete.add(configId);
                } else {
                    this.ignore.add(configId);
                }
            }

            private boolean fieldConfigIsExclusiveToScheme(Long configId) {
                List specificConfigs = FieldConfigPersisterImpl.this.delegator.findByAnd(MAPPING_TABLE, EasyMap.build((Object)CONFIG_COLUMN, (Object)configId));
                for (GenericValue fieldConfigIssueType : specificConfigs) {
                    if (fieldConfigSchemeId.equals(fieldConfigIssueType.getLong(SCHEME_COLUMN))) continue;
                    return false;
                }
                return true;
            }
        }
        return new ExclusiveConfigFinder().process();
    }

    public FieldConfig getFieldConfig(Long configId) {
        GenericValue gv = this.findById(configId);
        ConfigurableField field = ManagerFactory.getFieldManager().getConfigurableField(gv.getString(ENTITY_FIELD));
        return this.transformToDomainObject(gv, field == null ? Collections.EMPTY_LIST : field.getConfigurationItemTypes());
    }

    public FieldConfig getFieldConfig(Long configId, ConfigurableField field) {
        GenericValue gv = this.findById(configId);
        if (gv != null) {
            return this.transformToDomainObject(gv, field.getConfigurationItemTypes());
        }
        return null;
    }

    public List getConfigForField(final ConfigurableField field) {
        List configs = this.getConfigGvsForCustomField(field);
        CollectionUtils.transform((Collection)configs, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return FieldConfigPersisterImpl.this.transformToDomainObject((GenericValue)input, field.getConfigurationItemTypes());
            }
        });
        return configs;
    }

    private Map transformToFieldsMap(FieldConfig config) {
        NotNullHashMap<String, Object> fields = new NotNullHashMap<String, Object>();
        fields.put(ENTITY_ID, config.getId());
        fields.put(ENTITY_NAME, config.getName());
        fields.put(ENTITY_DESCRIPTION, config.getDescription());
        fields.put(ENTITY_FIELD, config.getFieldId());
        return fields;
    }

    private FieldConfig transformToDomainObject(GenericValue createdGV, List configurationItemTypes) {
        Long id = createdGV.getLong(ENTITY_ID);
        String name = createdGV.getString(ENTITY_NAME);
        String desc = createdGV.getString(ENTITY_DESCRIPTION);
        String fieldId = createdGV.getString(ENTITY_FIELD);
        return new FieldConfigImpl(id, name, desc, configurationItemTypes, fieldId);
    }

    private List getConfigGvsForCustomField(ConfigurableField field) {
        Map fields = EasyMap.build((Object)ENTITY_FIELD, (Object)field.getId());
        List sortBy = EasyList.build((Object)ENTITY_ID);
        return this.delegator.findByAnd(ENTITY_TABLE_NAME, fields, sortBy);
    }

    private GenericValue findById(Long configId) {
        Map fields = EasyMap.build((Object)ENTITY_ID, (Object)configId);
        return this.delegator.findByPrimaryKey(ENTITY_TABLE_NAME, fields);
    }
}

