/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.StatusSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.StatusStatisticsMapper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class StatusSystemField
extends NavigableFieldImpl
implements SearchableField {
    private final StatusStatisticsMapper statusStatisticsMapper;
    private final ConstantsManager constantsManager;
    private final SearchHandlerFactory searchHandlerFactory;

    public StatusSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, StatusStatisticsMapper statusStatisticsMapper, ConstantsManager constantsManager, StatusSearchHandlerFactory searchHandlerFactory) {
        super("status", "issue.field.status", "issue.column.heading.status", "DESC", velocityManager, applicationProperties, authenticationContext);
        this.statusStatisticsMapper = statusStatisticsMapper;
        this.constantsManager = constantsManager;
        this.searchHandlerFactory = searchHandlerFactory;
    }

    public LuceneFieldSorter getSorter() {
        return this.statusStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        Status status = issue.getStatusObject();
        velocityParams.put(this.getId(), status);
        return this.renderTemplate("status-columnview.vm", velocityParams);
    }

    private Long getStatusTypeIdByName(String stringValue) throws FieldValidationException {
        for (GenericValue statusGV : this.constantsManager.getStatuses()) {
            if (!stringValue.equalsIgnoreCase(statusGV.getString("name"))) continue;
            return Long.valueOf(statusGV.getString("id"));
        }
        throw new FieldValidationException("Invalid status name '" + stringValue + "'.");
    }

    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        Status status;
        Long statusId;
        if (TextUtils.stringSet((String)changeHistory) && (statusId = this.getStatusTypeIdByName(changeHistory)) != null && (status = this.constantsManager.getStatusObject(statusId.toString())) != null) {
            return status.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }
}

