/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.CommentField;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.rest.CommentFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.search.handlers.CommentSearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.bulkedit.BulkWorkflowTransition;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class CommentSystemField
extends AbstractOrderableField
implements RenderableField,
UnscreenableField,
CommentField,
RestAwareField,
RestFieldOperations {
    public static final String CREATE_COMMENT = "comment.create.param";
    public static final String EDIT_COMMENT = "comment.edit.param";
    public static final String REMOVE_COMMENT = "comment.remove.param";
    private static final Logger log = Logger.getLogger(CommentSystemField.class);
    private static final String COMMENT_NAME_KEY = "issue.field.comment";
    private static final String COMMENT_EDIT_TEMPLATE = "comment-edit.vm";
    public static final String PARAM_GROUP_LEVEL = "groupLevel";
    public static final String PARAM_COMMENT_LEVEL = "commentLevel";
    public static final String PARAM_ROLE_LEVEL = "roleLevel";
    public static final String PARAM_COMMENT_ID = "comment:id";
    private final RendererManager rendererManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CommentService commentService;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectFactory projectFactory;
    private final GroupManager groupManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final TimeZoneManager timeZoneManager;
    private final CommentManager commentManager;

    public CommentSystemField(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, CommentService commentService, ProjectRoleManager projectRoleManager, ProjectFactory projectFactory, CommentSearchHandlerFactory searchHandlerFactory, GroupManager groupManager, JiraBaseUrls jiraBaseUrls, TimeZoneManager timeZoneManager, CommentManager commentManager) {
        super("comment", COMMENT_NAME_KEY, velocityManager, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
        this.authenticationContext = authenticationContext;
        this.commentService = commentService;
        this.projectRoleManager = projectRoleManager;
        this.projectFactory = projectFactory;
        this.groupManager = groupManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.timeZoneManager = timeZoneManager;
        this.commentManager = commentManager;
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] commentId;
        HashMap<String, String> commentParams = new HashMap<String, String>();
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            commentParams.put(this.getId(), value[0]);
        }
        CommentVisibility commentVisibility = new CommentVisibility(params, PARAM_COMMENT_LEVEL);
        commentParams.put(PARAM_GROUP_LEVEL, commentVisibility.getGroupLevel());
        commentParams.put(PARAM_ROLE_LEVEL, commentVisibility.getRoleLevel());
        if (params.containsKey(CREATE_COMMENT)) {
            commentParams.put(CREATE_COMMENT, (String)params.get(CREATE_COMMENT));
        } else if (params.containsKey(EDIT_COMMENT)) {
            commentParams.put(EDIT_COMMENT, (String)params.get(EDIT_COMMENT));
        }
        if (params.containsKey(PARAM_COMMENT_ID) && (commentId = (String[])params.get(PARAM_COMMENT_ID)) != null && commentId.length > 0) {
            commentParams.put(PARAM_COMMENT_ID, commentId[0]);
        }
        return commentParams;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map commentParams;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateVelocityParams(fieldLayoutItem, null, velocityParams);
        if (operationContext != null && operationContext.getFieldValuesHolder() != null && operationContext.getFieldValuesHolder().containsKey(this.getId()) && (commentParams = (Map)operationContext.getFieldValuesHolder().get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
            this.populateParamsWithSelectedValue(commentParams, velocityParams);
        }
        return this.renderTemplate(COMMENT_EDIT_TEMPLATE, velocityParams);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map commentParams;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateVelocityParams(fieldLayoutItem, operationContext != null ? operationContext.getFieldValuesHolder() : null, velocityParams);
        if (operationContext != null && operationContext.getFieldValuesHolder() != null && operationContext.getFieldValuesHolder().containsKey(this.getId()) && (commentParams = (Map)operationContext.getFieldValuesHolder().get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
            this.populateParamsWithSelectedValue(commentParams, velocityParams);
        }
        return this.renderTemplate(COMMENT_EDIT_TEMPLATE, velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Comment system field does not know how to obtain a comment value given an Issue.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        IssueRenderContext context = issue != null ? issue.getIssueRenderContext() : new IssueRenderContext(null);
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        Map valueMap = (Map)value;
        velocityParams.put("value", this.rendererManager.getRenderedContent(rendererType, (String)valueMap.get(this.getId()), context));
        if (valueMap.containsKey(PARAM_GROUP_LEVEL)) {
            velocityParams.put(PARAM_GROUP_LEVEL, valueMap.get(PARAM_GROUP_LEVEL));
        }
        if (valueMap.containsKey(PARAM_ROLE_LEVEL)) {
            ProjectRole projectRole;
            String roleId = (String)valueMap.get(PARAM_ROLE_LEVEL);
            if (roleId != null && (projectRole = this.projectRoleManager.getProjectRole(new Long(roleId))) != null) {
                velocityParams.put("selectedRoleName", projectRole.getName());
            }
            velocityParams.put(PARAM_ROLE_LEVEL, roleId);
        }
        return this.renderTemplate("comment-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 15);
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        HashMap<String, String> commentParams = new HashMap<String, String>();
        commentParams.put(this.getId(), "");
        commentParams.put(PARAM_GROUP_LEVEL, null);
        fieldValuesHolder.put(this.getId(), commentParams);
    }

    public void populateAdditionalInputs(Map fieldValuesHolder, Map additionalInputs) {
        String comment;
        Map commentParams = (Map)fieldValuesHolder.get(this.getId());
        if (commentParams != null && StringUtils.isNotBlank((String)(comment = (String)commentParams.get(this.getId())))) {
            additionalInputs.put("comment", commentParams.get(this.getId()));
            additionalInputs.put(PARAM_COMMENT_LEVEL, commentParams.get(PARAM_GROUP_LEVEL));
            additionalInputs.put(PARAM_ROLE_LEVEL, commentParams.get(PARAM_ROLE_LEVEL));
        }
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        this.populateDefaults(fieldValuesHolder, issue);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        Map commentParams = (Map)fieldValuesHolder.get(this.getId());
        String body = (String)commentParams.get(this.getId());
        String groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL);
        String roleLevel = (String)commentParams.get(PARAM_ROLE_LEVEL);
        User user = this.authenticationContext.getLoggedInUser();
        if (commentParams.containsKey(EDIT_COMMENT)) {
            this.validateEditComment(errorCollectionToAddTo, issue, commentParams, body, groupLevel, roleLevel, user);
        } else {
            this.validateCreateComment(errorCollectionToAddTo, issue, commentParams, body, groupLevel, roleLevel, user);
        }
    }

    private void validateCreateComment(ErrorCollection errorCollectionToAddTo, Issue issue, Map commentParams, String body, String groupLevel, String roleLevel, User user) {
        if (StringUtils.isNotBlank((String)body)) {
            this.commentService.hasPermissionToCreate(user, issue, errorCollectionToAddTo);
        }
        if (commentParams.get(CREATE_COMMENT) != null) {
            this.commentService.isValidCommentBody(body, errorCollectionToAddTo);
        }
        this.commentService.isValidCommentData(user, issue, groupLevel, roleLevel, errorCollectionToAddTo);
    }

    private void validateEditComment(ErrorCollection errorCollectionToAddTo, Issue issue, Map commentParams, String body, String groupLevel, String roleLevel, User user) {
        if (commentParams.get(PARAM_COMMENT_ID) != null) {
            try {
                this.commentService.isValidCommentBody(body, errorCollectionToAddTo);
                Long commentIdAsLong = Long.valueOf((String)commentParams.get(PARAM_COMMENT_ID));
                this.commentService.hasPermissionToEdit((JiraServiceContext)new JiraServiceContextImpl(user, errorCollectionToAddTo), commentIdAsLong);
                this.commentService.isValidCommentData(user, issue, groupLevel, roleLevel, errorCollectionToAddTo);
            }
            catch (NumberFormatException ex) {
                errorCollectionToAddTo.addError("comment", "invalid comment id specified.");
            }
        } else {
            errorCollectionToAddTo.addError("comment", "no comment id specified.");
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, Object value) {
        throw new UnsupportedOperationException("CreateValue on the comment system field is unsupported.");
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Map commentParams = (Map)modifiedValue.getNewValue();
        String body = (String)commentParams.get(this.getId());
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        body = (String)this.rendererManager.getRendererForType(rendererType).transformFromEdit((Object)body);
        if (commentParams.containsKey(EDIT_COMMENT)) {
            this.editComment(issue, issueChangeHolder, commentParams, body);
        } else if (StringUtils.isNotBlank((String)body)) {
            this.createComment(issue, issueChangeHolder, commentParams, body);
        }
    }

    private void editComment(Issue issue, IssueChangeHolder issueChangeHolder, Map commentParams, String body) {
        String roleLevelIdStr;
        String groupLevel;
        User user = this.authenticationContext.getLoggedInUser();
        long commentId = Long.valueOf((String)commentParams.get(PARAM_COMMENT_ID));
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableComment mutableComment = this.commentService.getMutableComment(user, Long.valueOf(commentId), (ErrorCollection)errorCollection);
        if (StringUtils.isNotBlank((String)body)) {
            mutableComment.setBody(body);
        }
        if ((groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL)) != null) {
            if (StringUtils.isEmpty((String)groupLevel)) {
                mutableComment.setGroupLevel(null);
            } else {
                mutableComment.setGroupLevel(groupLevel);
                mutableComment.setRoleLevelId(null);
            }
        }
        if ((roleLevelIdStr = (String)commentParams.get(PARAM_ROLE_LEVEL)) != null) {
            if (StringUtils.isEmpty((String)roleLevelIdStr)) {
                mutableComment.setRoleLevelId(null);
            } else {
                mutableComment.setRoleLevelId(new Long(roleLevelIdStr));
                mutableComment.setGroupLevel(null);
            }
        }
        this.commentService.update(user, mutableComment, true, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            log.error((Object)("Error updating comment id '" + commentId + "' Error(s): '" + errorCollection.toString() + "'"));
        }
    }

    private void createComment(Issue issue, IssueChangeHolder issueChangeHolder, Map commentParams, String body) {
        String groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL);
        Object rolelLevelId = commentParams.get(PARAM_ROLE_LEVEL);
        Long roleLevelId = rolelLevelId == null ? null : new Long((String)rolelLevelId);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        User user = this.authenticationContext.getLoggedInUser();
        Comment comment = this.commentService.create(user, issue, body, groupLevel, roleLevelId, false, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            log.error((Object)("There was an error creating a comment value: " + errorCollection.toString()));
        } else {
            issueChangeHolder.setComment(comment);
        }
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        Map commentParams;
        if (fieldValueHolder.containsKey(this.getId()) && StringUtils.isNotBlank((String)((String)(commentParams = (Map)fieldValueHolder.get(this.getId())).get(this.getId())))) {
            issue.setExternalFieldValue(this.getId(), fieldValueHolder.get(this.getId()));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        if (originalIssues.size() > 1) {
            for (Issue originalIssue : originalIssues) {
                String targetRendererType;
                String rendererType;
                FieldLayoutItem fieldLayoutItem = null;
                try {
                    fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(originalIssue.getProject(), originalIssue.getIssueTypeObject().getId()).getFieldLayoutItem(this.getId());
                }
                catch (DataAccessException e) {
                    log.warn((Object)(this.getName() + " field was unable to resolve the field layout item for issue " + originalIssue.getId()), (Throwable)e);
                }
                if (this.rendererTypesEqual(rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, targetRendererType = targetFieldLayoutItem != null ? targetFieldLayoutItem.getRendererType() : null)) continue;
                return new MessagedResult(false, this.getAuthenticationContext().getI18nHelper().getText("renderer.bulk.move.warning"), 1);
            }
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("Remove is not done through the system field for comment.");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return false;
    }

    public Object getValueFromParams(Map params) throws FieldValidationException {
        if (params.containsKey(this.getId())) {
            return params.get(this.getId());
        }
        return null;
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
    }

    public String getValueFromIssue(Issue issue) {
        throw new UnsupportedOperationException("Comment system field does not know how to obtain a comment value given an Issue.");
    }

    public boolean isRenderable() {
        return true;
    }

    private void populateVelocityParams(FieldLayoutItem fieldLayoutItem, Map fieldValuesHolder, Map velocityParams) {
        Map commentParams;
        if (fieldValuesHolder != null && (commentParams = (Map)fieldValuesHolder.get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
        }
        velocityParams.put("rendererParams", new HashMap());
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        velocityParams.put("rendererDescriptor", this.rendererManager.getRendererForType(rendererType).getDescriptor());
        velocityParams.put("groupLevels", this.getGroupLevels());
        Issue issue = (Issue)velocityParams.get("issue");
        if (issue != null) {
            velocityParams.put("roleLevels", this.getRoleLevels(issue));
        } else {
            GenericValue project;
            BulkWorkflowTransition bulkWorkflowTransition;
            BulkEditBean bulkEditBean;
            Object action = velocityParams.get("action");
            if (action != null && action instanceof BulkWorkflowTransition && (bulkEditBean = (bulkWorkflowTransition = (BulkWorkflowTransition)((Object)action)).getBulkEditBean()) != null && (project = bulkEditBean.getProject()) != null) {
                velocityParams.put("roleLevels", this.getRoleLevels(project));
            }
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        String rendererType = null;
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (fieldLayout.isFieldHidden(this.getId())) {
                return "bulk.edit.unavailable.hidden";
            }
            if (StringUtils.isBlank(rendererType)) {
                rendererType = fieldLayout.getRendererTypeForField("comment");
                continue;
            }
            if (rendererType.equals(fieldLayout.getRendererTypeForField("comment"))) continue;
            return "bulk.edit.unavailable.different.renderers";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    private Collection getGroupLevels() {
        ArrayList groups;
        if (this.authenticationContext.getUser() == null || !this.commentService.isGroupVisiblityEnabled()) {
            groups = Collections.EMPTY_LIST;
        } else {
            Collection groupNames = this.groupManager.getGroupNamesForUser(this.authenticationContext.getUser().getName());
            ArrayList userGroups = new ArrayList(groupNames);
            Collections.sort(userGroups);
            groups = userGroups;
        }
        return groups;
    }

    private Collection getRoleLevels(GenericValue project) {
        Collection roles;
        if (project == null) {
            throw new NullPointerException("project GenericValue was null");
        }
        if (this.commentService.isProjectRoleVisiblityEnabled()) {
            User user = this.authenticationContext.getUser();
            roles = this.projectRoleManager.getProjectRoles(user, this.projectFactory.getProject(project));
        } else {
            roles = Collections.EMPTY_LIST;
        }
        return roles;
    }

    private Collection getRoleLevels(Issue issue) {
        Collection roles;
        if (this.commentService.isProjectRoleVisiblityEnabled()) {
            User user = this.authenticationContext.getUser();
            roles = this.projectRoleManager.getProjectRoles(user, issue.getProjectObject());
        } else {
            roles = Collections.EMPTY_LIST;
        }
        return roles;
    }

    private void populateParamsWithSelectedValue(Map commentParams, Map velocityParams) {
        if (commentParams.get(PARAM_ROLE_LEVEL) != null) {
            velocityParams.put(PARAM_COMMENT_LEVEL, "role:" + commentParams.get(PARAM_ROLE_LEVEL));
        } else if (commentParams.get(PARAM_GROUP_LEVEL) != null) {
            velocityParams.put(PARAM_COMMENT_LEVEL, "group:" + commentParams.get(PARAM_GROUP_LEVEL));
        }
    }

    public FieldTypeInfo getFieldTypeInfo(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, IssueContext issue) {
        return new FieldTypeInfo(JiraDataTypes.getType((Field)this), true, false, null, fieldLayoutItem.isRequired(), !fieldLayoutItem.isHidden(), true, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"comment", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new CommentFieldOperationsHandler(this.commentManager);
    }

    public JsonData getJsonFromIssue(Issue issue) {
        List comments = this.commentService.getCommentsForUser(this.authenticationContext.getLoggedInUser(), issue, (ErrorCollection)new SimpleErrorCollection());
        Collection beans = CommentJsonBean.shortBeans((Collection)comments, (JiraBaseUrls)this.jiraBaseUrls, (TimeZoneManager)this.timeZoneManager, (ProjectRoleManager)this.projectRoleManager);
        return new JsonData((Object)beans);
    }
}

